<?php
// certificate_view.php — web view of a certificate using the shared template
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';

require_login(); // keep or remove if you want public view

$code = trim($_GET['code'] ?? '');
if ($code === '') { echo "Missing code"; exit; }

// Load certificate + related
$st = db()->prepare("
  SELECT c.*,
         u.name AS learner_name, u.email AS learner_email, u.id_number AS learner_idno,
         co.title AS course_title, co.nqf_level, co.credits, co.course_number, co.expiry_months
  FROM certificates c
  LEFT JOIN users u ON u.id=c.user_id
  LEFT JOIN courses co ON co.id=c.course_id
  WHERE c.cert_code=? LIMIT 1
");
$st->execute([$code]);
$row = $st->fetch();
if (!$row){ echo "Certificate not found."; exit; }

// Prepare data structs for the template
$CERT = [
  'cert_code'  => $row['cert_code'],
  'issued_at'  => $row['issued_at'] ?? '',
  'expires_at' => $row['expires_at'] ?? '',
];

$LEARN = [
  'name'      => $row['learner_name'] ?? '',
  'id_number' => $row['learner_idno'] ?? '',
];

$COURSE = [
  'title'          => $row['course_title'] ?? '',
  'nqf_level'      => $row['nqf_level'] ?? null,
  'credits'        => $row['credits'] ?? null,
  'course_number'  => $row['course_number'] ?? '',
  'expiry_months'  => $row['expiry_months'] ?? null,
];

$for_pdf = false;

include __DIR__ . '/templates/header.php';
?>
<h1>Certificate</h1>
<div class="panel"><div class="panel__body">
  <a class="btn btn-primary btn-small" href="<?= e(url('certificate_pdf.php?code='.urlencode($row['cert_code']))) ?>">Download PDF</a>
  <a class="btn btn-small" href="<?= e(url('verify.php?code='.urlencode($row['cert_code']))) ?>" target="_blank">Open Verify</a>
</div></div>

<?php include __DIR__ . '/templates/certificate_render.php'; ?>

<?php include __DIR__ . '/templates/footer.php'; ?>
