<?php
// certificate_view.php — on-screen view using the unified bundle
ini_set('display_errors',1); error_reporting(E_ALL);

require_once __DIR__ . '/lib/helpers.php';
require_once __DIR__ . '/lib/cert_bundle.php';

$code = $_GET['code'] ?? '';
try {
  $B = load_certificate_bundle($code);
} catch (Throwable $e) {
  include __DIR__ . '/templates/header.php';
  echo "<h1>Certificate</h1><div class='alert alert-error'>".e($e->getMessage())."</div>";
  include __DIR__ . '/templates/footer.php';
  exit;
}

// Variables expected by certificate_render.php
$CERT        = $B['CERT'];
$LEARN       = $B['LEARN'];
$COURSE      = $B['COURSE'];
$learner_id  = $B['learner_id'];   // unified enforced ID
$for_pdf     = false;

// Normalize dates & code for consistent display
$CERT['issued_at']  = $B['issued_fmt'];
$CERT['expires_at'] = $B['expires_fmt'];
$CERT['cert_code']  = $B['display_code'];

include __DIR__ . '/templates/header.php';
include __DIR__ . '/templates/certificate_render.php';
include __DIR__ . '/templates/footer.php';
