<?php
// admin/backfill_ids.php — one-time migration to canonicalize learner ID
ini_set('display_errors',1); error_reporting(E_ALL);

require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/helpers.php';
require_once __DIR__ . '/../lib/pii.php';   // encryption helpers
require_login();
if (!can('admin')) { http_response_code(403); echo "Admins only."; exit; }

function is_13d($s){ return preg_match('/^\d{13}$/', $s); }
function last4($s){ return substr(preg_replace('/\D+/','',$s), -4) ?: null; }

$updated = 0;

// Fetch minimal fields needed
$st = db()->query("
  SELECT id, id_number, national_id_enc, national_id_last4, national_id_enc, national_id_last4
  FROM users
  ORDER BY id ASC
");
$users = $st->fetchAll();

foreach ($users as $u) {
  $nid_enc = $u['national_id_enc'];
  $nid_l4  = $u['national_id_last4'];

  // Option A: promote plaintext id_number -> encrypted national_id_enc
  if (empty($nid_enc) && !empty($u['id_number']) && is_13d($u['id_number'])) {
    $enc  = pii_encrypt($u['id_number']);
    $l4   = last4($u['id_number']);
    $upd  = db()->prepare("UPDATE users SET national_id_enc=?, national_id_last4=?, id_number=NULL WHERE id=?");
    $upd->execute([$enc, $l4, $u['id']]);
    $updated++;
    continue;
  }

  // Option B: if still empty, copy gov_* -> national_*
  if (empty($nid_enc) && !empty($u['national_id_enc'])) {
    $l4 = !empty($u['national_id_last4']) ? $u['national_id_last4'] : null;
    $upd = db()->prepare("UPDATE users SET national_id_enc=?, national_id_last4=? WHERE id=?");
    $upd->execute([$u['national_id_enc'], $l4, $u['id']]);
    $updated++;
  }
}

include __DIR__ . '/../templates/header.php';
echo "<h1>ID Backfill</h1>";
echo "<div class='alert alert-ok'>Updated {$updated} user(s). Safe to run again; it only fills missing national_id_enc.</div>";
echo "<p><a class='btn' href='".e(url('../dashboard.php'))."'>Back to Dashboard</a></p>";
include __DIR__ . '/../templates/footer.php';
