<?php
// One-time: copy legacy users.id_number into encrypted national_id_* columns.
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/helpers.php';
require_once __DIR__ . '/../lib/pii.php';

require_login();
if (!can('admin')) { http_response_code(403); echo "Admins only."; exit; }

$bad=0; $ok=0;
$st = db()->query("SELECT id, id_number, national_id_enc FROM users");
while ($u = $st->fetch()) {
  $plain = trim((string)($u['id_number'] ?? ''));
  if ($plain === '' || !preg_match('/^\d{13}$/', $plain)) { continue; } // skip invalid legacy data

  if (!empty($u['national_id_enc'])) { continue; } // already migrated

  try {
    $enc   = pii_encrypt($plain);
    $last4 = substr($plain, -4);
    $up = db()->prepare("UPDATE users SET national_id_enc=?, national_id_last4=? WHERE id=?");
    $up->execute([$enc, $last4, $u['id']]);
    $ok++;
  } catch (Throwable $e) {
    $bad++;
  }
}

echo "Done. Migrated: {$ok}, Skipped/Failed: {$bad}. ";
echo '<a href="'.e(url('../admin/ids_queue.php')).'">Open ID Queue</a>';
