<?php
// admin/companies_queue.php  list companies (resilient schema)
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';

require_login();
if (!can('admin')) { http_response_code(403); echo "Admins only."; exit; }

// check optional cols
function has_col($t,$c){ try{$s=db()->prepare("SHOW COLUMNS FROM `$t` LIKE ?");$s->execute([$c]);return (bool)$s->fetch();}catch(Throwable $e){return false;} }
$hasCreatedBy = has_col('companies','created_by');
$hasApproved  = has_col('companies','approved_at');

$sql = "SELECT c.id, c.name, c.address, c.billing_email, c.contact_phone";
if ($hasApproved)  $sql .= ", c.approved_at";
if ($hasCreatedBy) $sql .= ", c.created_by, u.name AS creator_name, u.email AS creator_email";
$sql .= " FROM companies c";
if ($hasCreatedBy) $sql .= " LEFT JOIN users u ON u.id=c.created_by";
$sql .= " ORDER BY c.id DESC LIMIT 100";

$rows=[];
try { $rows = db()->query($sql)->fetchAll(); }
catch(Throwable $e){
  include __DIR__.'/../templates/header.php';
  echo "<h1>Companies</h1>";
  echo "<div class='alert alert-error'>DB error: ".e($e->getMessage())."</div>";
  include __DIR__.'/../templates/footer.php'; exit;
}

include __DIR__.'/../templates/header.php';
?>
<h1>Companies</h1>
<table class="mini">
  <tr>
    <th>ID</th><th>Name</th><th>Billing Email</th><th>Phone</th>
    <?php if ($hasApproved): ?><th>Approved</th><?php endif; ?>
    <?php if ($hasCreatedBy): ?><th>Created by</th><?php endif; ?>
    <th>Actions</th>
  </tr>
  <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= (int)$r['id'] ?></td>
      <td><?= e($r['name']) ?></td>
      <td><?= e($r['billing_email'] ?? '') ?></td>
      <td><?= e($r['contact_phone'] ?? '') ?></td>
      <?php if ($hasApproved): ?><td><?= e($r['approved_at'] ?? '') ?></td><?php endif; ?>
      <?php if ($hasCreatedBy): ?>
        <td>
          <?php
            $cn = trim($r['creator_name'] ?? '');
            $ce = trim($r['creator_email'] ?? '');
            echo $cn ? e($cn).($ce? " <span class='small muted'>(".e($ce).")</span>" : '') : '';
          ?>
        </td>
      <?php endif; ?>
      <td><a class="btn btn-small" href="<?= e(url('company/view.php?id='.(int)$r['id'])) ?>">Open</a></td>
    </tr>
  <?php endforeach; ?>
</table>
<?php include __DIR__.'/../templates/footer.php'; ?>
