<?php
// /lmis/admin/company_approve.php — POST approve/reject
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';

require_login();
if (!can('admin')) { http_response_code(403); echo "Admins only."; exit; }
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { http_response_code(405); echo "POST only."; exit; }

$cid = (int)($_POST['company_id'] ?? 0);
$act = $_POST['action'] ?? '';
if ($cid<=0 || !in_array($act,['approve','reject'],true)) { http_response_code(400); echo "Bad request."; exit; }

if ($act==='approve') {
  $st = db()->prepare("UPDATE companies SET status='approved', verified_at=NOW() WHERE id=?");
  $st->execute([$cid]);
} else {
  $st = db()->prepare("UPDATE companies SET status='rejected' WHERE id=?");
  $st->execute([$cid]);
}

redirect('companies_queue.php');
