<?php
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';
require_login();
require_ability('admin');

$id = (int)($_GET['id'] ?? 0); // course id
$st = db()->prepare("SELECT id,title FROM courses WHERE id=?");
$st->execute([$id]);
$course = $st->fetch();
if (!$course) { redirect('courses.php'); }

$cats = db()->query("SELECT id,name FROM course_categories ORDER BY name")->fetchAll();

// Save
$ok=''; $err='';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $sel = $_POST['cats'] ?? []; // array of category ids
  // clear old
  $del = db()->prepare("DELETE FROM course_category_map WHERE course_id=?");
  $del->execute([$id]);
  // insert new
  if ($sel) {
    $ins = db()->prepare("INSERT INTO course_category_map (course_id,category_id) VALUES (?,?)");
    foreach ($sel as $cid) {
      $ins->execute([$id,(int)$cid]);
    }
  }
  $ok='Saved categories.';
}

// load selected
$have = db()->prepare("SELECT category_id FROM course_category_map WHERE course_id=?");
$have->execute([$id]); $rows = $have->fetchAll();
$selected = array_column($rows,'category_id');

include __DIR__.'/../templates/header.php';
?>
<h1>Categories for: <?= e($course['title']) ?></h1>
<?php if ($err): ?><div class="alert alert-error"><?= e($err) ?></div><?php endif; ?>
<?php if ($ok):  ?><div class="alert alert-ok"><?= e($ok) ?></div><?php endif; ?>

<form method="post" class="form-card">
  <?php foreach($cats as $c): ?>
    <label style="display:block; margin-bottom:8px;">
      <input type="checkbox" name="cats[]" value="<?= (int)$c['id'] ?>" <?= in_array($c['id'],$selected)?'checked':''; ?>>
      <?= e($c['name']) ?>
    </label>
  <?php endforeach; ?>
  <div class="form__actions">
    <button class="btn btn-primary">Save</button>
    <a class="btn btn-outline" href="courses.php">Back</a>
  </div>
</form>

<?php include __DIR__.'/../templates/footer.php'; ?>
