<?php
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';
require_login();
require_ability('admin');

$err=''; $ok='';

if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action']??'')==='create') {
  $name = trim($_POST['name'] ?? '');
  if ($name==='') { $err='Type a category name.'; }
  else {
    $ins = db()->prepare("INSERT INTO course_categories (name) VALUES (?)");
    try { $ins->execute([$name]); $ok='Category created.'; }
    catch(Exception $e){ $err='Category already exists?'; }
  }
}

if (($_GET['del'] ?? '')!=='') {
  $id = (int)$_GET['del'];
  $del = db()->prepare("DELETE FROM course_categories WHERE id=?");
  $del->execute([$id]);
  redirect('course_categories.php');
}

$cats = db()->query("SELECT id,name FROM course_categories ORDER BY name")->fetchAll();

include __DIR__.'/../templates/header.php';
?>
<h1>Course Categories</h1>
<?php if ($err): ?><div class="alert alert-error"><?= e($err) ?></div><?php endif; ?>
<?php if ($ok):  ?><div class="alert alert-ok"><?= e($ok) ?></div><?php endif; ?>

<form method="post" class="form-card">
  <input type="hidden" name="action" value="create">
  <label class="field">
    <span class="field__label">Category name</span>
    <input class="field__input" name="name" placeholder="Driver Safety" required>
  </label>
  <div class="form__actions">
    <button class="btn btn-primary">Add Category</button>
  </div>
</form>

<h3>All categories</h3>
<table class="mini">
  <tr><th>Name</th><th>Actions</th></tr>
  <?php foreach($cats as $c): ?>
    <tr>
      <td><?= e($c['name']) ?></td>
      <td><a class="btn btn-small" href="?del=<?= (int)$c['id'] ?>" onclick="return confirm('Delete category?')">Delete</a></td>
    </tr>
  <?php endforeach; ?>
</table>

<?php include __DIR__.'/../templates/footer.php'; ?>
