<?php
ini_set('display_errors',1);
error_reporting(E_ALL);

// admin/course_edit.php — aligns with your columns:
// title, description, duration_days, type, nqf_level, credits,
// course_number, expiry_months, price, thumbnail_url

require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';

require_login();
require_ability('admin');

// helpers for safe echo
function val($row, $key)  { return e(isset($row[$key]) && $row[$key] !== null ? (string)$row[$key] : ''); }
function num($row, $key)  { return e(isset($row[$key]) && $row[$key] !== null ? (string)$row[$key] : ''); }

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { redirect('courses.php'); }

$err=''; $ok='';

// Load course (explicit columns)
$st = db()->prepare("
  SELECT id, title,
         COALESCE(description,'')    AS description,
         duration_days,
         COALESCE(type,'')           AS type,
         nqf_level,
         credits,
         COALESCE(course_number,'')  AS course_number,
         expiry_months,
         price,
         COALESCE(thumbnail_url,'')  AS thumbnail_url
  FROM courses WHERE id=? LIMIT 1
");
$st->execute([$id]);
$course = $st->fetch();
if (!$course) { redirect('courses.php'); }

// Save
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $title   = trim($_POST['title'] ?? '');
  $desc    = trim($_POST['description'] ?? '');
  $type    = trim($_POST['type'] ?? '');
  $nqf     = ($_POST['nqf_level']     === '' ? null : (int)$_POST['nqf_level']);
  $days    = ($_POST['duration_days'] === '' ? null : (int)$_POST['duration_days']);
  $credits = ($_POST['credits']       === '' ? null : (int)$_POST['credits']);
  $cno     = trim($_POST['course_number'] ?? '');
  $exp     = ($_POST['expiry_months'] === '' ? null : (int)$_POST['expiry_months']);
  $price   = ($_POST['price']         === '' ? null : (float)$_POST['price']);
  $thumb   = trim($_POST['thumbnail_url'] ?? '');

  if ($title === '') {
    $err = 'Please type a title.';
  } else {
    $u = db()->prepare("
      UPDATE courses
         SET title=?, description=?, duration_days=?, type=?, nqf_level=?, credits=?,
             course_number=?, expiry_months=?, price=?, thumbnail_url=?
       WHERE id=?
    ");
    $u->execute([$title,$desc,$days,$type,$nqf,$credits,$cno,$exp,$price,$thumb,$id]);
    $ok = 'Saved.';
    // reload fresh
    $st->execute([$id]); $course = $st->fetch();
  }
}

// Optional info panes (don’t crash if tables not present)
$catnames = [];
try {
  $cats = db()->prepare("SELECT cc.name
                         FROM course_category_map m
                         JOIN course_categories cc ON cc.id=m.category_id
                         WHERE m.course_id=? ORDER BY cc.name");
  $cats->execute([$id]);
  $catnames = array_column($cats->fetchAll(), 'name');
} catch (Throwable $e) { $catnames = []; }

$units = []; $total_credits = 0;
try {
  $us = db()->prepare("SELECT us.us_no, us.title, us.credits
                       FROM course_unit_standards cus
                       JOIN unit_standards us ON us.id=cus.unit_standard_id
                       WHERE cus.course_id=? ORDER BY us.us_no");
  $us->execute([$id]);
  $units = $us->fetchAll();
  foreach ($units as $urow) { $total_credits += (int)($urow['credits'] ?? 0); }
} catch (Throwable $e) {
  $units = []; $total_credits = 0;
}

include __DIR__.'/../templates/header.php';
?>
<h1>Edit Course</h1>

<?php if ($err): ?><div class="alert alert-error"><?= e($err) ?></div><?php endif; ?>
<?php if ($ok):  ?><div class="alert alert-ok"><?= e($ok) ?></div><?php endif; ?>

<form method="post" class="form-card">
  <label class="field">
    <span class="field__label">Title</span>
    <input class="field__input" name="title" value="<?= val($course,'title') ?>" required>
  </label>

  <label class="field">
    <span class="field__label">Description</span>
    <textarea class="field__input" name="description" rows="5" placeholder="What will learners achieve?"><?= val($course,'description') ?></textarea>
  </label>

  <div class="grid-2">
    <label class="field">
      <span class="field__label">Duration (days)</span>
      <input class="field__input" type="number" name="duration_days" min="1" value="<?= num($course,'duration_days') ?>">
    </label>
    <label class="field">
      <span class="field__label">Type (Online / Blended / Practical)</span>
      <input class="field__input" name="type" value="<?= val($course,'type') ?>" placeholder="Online / Blended / Practical">
    </label>
  </div>

  <div class="grid-2">
    <label class="field">
      <span class="field__label">NQF Level</span>
      <input class="field__input" type="number" min="1" max="10" name="nqf_level" value="<?= num($course,'nqf_level') ?>">
    </label>
    <label class="field">
      <span class="field__label">Credits</span>
      <input class="field__input" type="number" min="0" name="credits" value="<?= num($course,'credits') ?>">
    </label>
  </div>

  <div class="grid-2">
    <label class="field">
      <span class="field__label">Course Number</span>
      <input class="field__input" name="course_number" value="<?= val($course,'course_number') ?>" placeholder="e.g., AIT-DD-001">
    </label>
    <label class="field">
      <span class="field__label">Expiry (months)</span>
      <input class="field__input" type="number" min="0" name="expiry_months" value="<?= num($course,'expiry_months') ?>" placeholder="e.g., 24">
    </label>
  </div>

  <div class="grid-2">
    <label class="field">
      <span class="field__label">Price (optional)</span>
      <input class="field__input" type="number" step="0.01" name="price" value="<?= num($course,'price') ?>" placeholder="e.g., 950.00">
    </label>
    <label class="field">
      <span class="field__label">Thumbnail URL (image)</span>
      <input class="field__input" name="thumbnail_url" value="<?= val($course,'thumbnail_url') ?>" placeholder="https://.../image.jpg">
    </label>
  </div>

  <div class="form__actions">
    <button class="btn btn-primary">Save</button>
    <a class="btn btn-outline" href="courses.php">Back</a>
    <a class="btn btn-small" href="course_assign_categories.php?id=<?= (int)$id ?>">Categories…</a>
  </div>
</form>

<div class="panel">
  <div class="panel__body">
    <h3>Categories</h3>
    <p><?= $catnames ? e(implode(', ', $catnames)) : '<span class="muted">No categories yet.</span>' ?></p>

    <h3>Unit Standards (auto-credits)</h3>
    <?php if ($units): ?>
      <ul class="bullets">
        <?php foreach($units as $u): ?>
          <li><?= e($u['us_no']) ?> — <?= e($u['title']) ?> (<?= (int)$u['credits'] ?> credits)</li>
        <?php endforeach; ?>
      </ul>
      <p><strong>Total credits:</strong> <?= (int)$total_credits ?></p>
    <?php else: ?>
      <p class="muted">No unit standards linked yet.</p>
    <?php endif; ?>
  </div>
</div>

<?php include __DIR__.'/../templates/footer.php'; ?>
