<?php
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';
require_login();
require_ability('admin'); // only admins manage courses

$err=''; $ok='';

// Create course (KISS: title only)
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action']??'')==='create') {
  $title = trim($_POST['title'] ?? '');
  if ($title==='') { $err='Please type a course title.'; }
  else {
    $st = db()->prepare("INSERT INTO courses (title) VALUES (?)");
    try { $st->execute([$title]); $ok='Course created.'; }
    catch(Exception $e){ $err='Could not create course.'; }
  }
}

// Load courses
$courses = db()->query("SELECT id, title FROM courses ORDER BY title")->fetchAll();

include __DIR__.'/../templates/header.php';
?>
<h1>Courses</h1>

<?php if ($err): ?><div class="alert alert-error"><?= e($err) ?></div><?php endif; ?>
<?php if ($ok):  ?><div class="alert alert-ok"><?= e($ok) ?></div><?php endif; ?>

<form method="post" class="form-card">
  <input type="hidden" name="action" value="create">
  <label class="field">
    <span class="field__label">Course title</span>
    <input class="field__input" name="title" placeholder="Defensive Driving Basics" required>
  </label>
  <div class="form__actions">
    <button class="btn btn-primary">Add Course</button>
  </div>
</form>

<h3>All courses</h3>
<table class="mini">
  <tr><th>Title</th><th>Actions</th></tr>
  <?php foreach($courses as $c): ?>
    <tr>
      <td><?= e($c['title']) ?></td>
      <td>
        <a class="btn btn-small" href="course_edit.php?id=<?= (int)$c['id'] ?>">Edit</a>
        <a class="btn btn-small" href="course_assign_categories.php?id=<?= (int)$c['id'] ?>">Categories</a>
      </td>
    </tr>
  <?php endforeach; ?>
</table>

<?php include __DIR__.'/../templates/footer.php'; ?>
