<?php
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';
require_login();
require_ability('admin'); // only admins manage mappings

// Handle create
$err=''; $ok='';
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action']??'')==='create') {
  $category = trim(strtolower($_POST['category'] ?? ''));
  $min = (int)($_POST['min_score'] ?? 0);
  $max = (int)($_POST['max_score'] ?? 0);
  $course_id = (int)($_POST['course_id'] ?? 0);

  if ($category==='' || $min<0 || $max<0 || $max<$min || $course_id<=0) {
    $err = 'Please fill all fields correctly.';
  } else {
    $st = db()->prepare("INSERT INTO score_training_map (category,min_score,max_score,course_id) VALUES (?,?,?,?)");
    $st->execute([$category,$min,$max,$course_id]);
    $ok = 'Mapping added.';
  }
}

// Handle delete
if (($_GET['del'] ?? '') !== '') {
  $id = (int)$_GET['del'];
  $del = db()->prepare("DELETE FROM score_training_map WHERE id=?");
  $del->execute([$id]);
  redirect('driver_scores_mapping.php');
}

// Load courses and mappings
$courses = db()->query("SELECT id,title FROM courses ORDER BY title")->fetchAll();
$maps = db()->query("SELECT m.*, c.title course
                     FROM score_training_map m
                     JOIN courses c ON c.id=m.course_id
                     ORDER BY m.category, m.min_score")->fetchAll();

include __DIR__.'/../templates/header.php';
?>
<h1>Driver Score → Training Mapping</h1>
<p class="small">Rule book: if a driver’s <em>category</em> score is within a range, recommend a course.</p>

<?php if ($err): ?><div class="alert alert-error"><?= e($err) ?></div><?php endif; ?>
<?php if ($ok):  ?><div class="alert alert-ok"><?= e($ok) ?></div><?php endif; ?>

<form method="post" class="form-card">
  <input type="hidden" name="action" value="create">
  <div class="grid-2">
    <label class="field">
      <span class="field__label">Category (e.g., speeding, fatigue)</span>
      <input class="field__input" name="category" placeholder="speeding" required>
    </label>
    <label class="field">
      <span class="field__label">Course</span>
      <select class="field__input" name="course_id" required>
        <option value="">Select course…</option>
        <?php foreach($courses as $c): ?>
          <option value="<?= (int)$c['id'] ?>"><?= e($c['title']) ?></option>
        <?php endforeach; ?>
      </select>
    </label>
  </div>
  <div class="grid-2">
    <label class="field">
      <span class="field__label">Min score (0–100)</span>
      <input class="field__input" type="number" name="min_score" min="0" max="100" value="0" required>
    </label>
    <label class="field">
      <span class="field__label">Max score (0–100)</span>
      <input class="field__input" type="number" name="max_score" min="0" max="100" value="60" required>
    </label>
  </div>
  <div class="form__actions">
    <button class="btn btn-primary">Add Mapping</button>
  </div>
</form>

<h3>Existing mappings</h3>
<table class="mini">
  <tr><th>Category</th><th>Range</th><th>Course</th><th></th></tr>
  <?php foreach($maps as $m): ?>
    <tr>
      <td><?= e($m['category']) ?></td>
      <td><?= (int)$m['min_score'] ?>–<?= (int)$m['max_score'] ?></td>
      <td><?= e($m['course']) ?></td>
      <td><a class="btn btn-small" href="?del=<?= (int)$m['id'] ?>" onclick="return confirm('Delete mapping?')">Delete</a></td>
    </tr>
  <?php endforeach; ?>
</table>

<?php include __DIR__.'/../templates/footer.php'; ?>
