<?php
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';
require_login();
require_ability('admin');

$ok=''; $err='';
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_FILES['csv'])) {
  if ($_FILES['csv']['error']===UPLOAD_ERR_OK) {
    $tmp = $_FILES['csv']['tmp_name'];
    $fh = fopen($tmp, 'r');
    if ($fh) {
      // First line headers: email,category,score,source
      $headers = fgetcsv($fh);
      if (!$headers) { $err='Empty file.'; }
      else {
        $count=0; $skipped=0;
        while (($row = fgetcsv($fh)) !== false) {
          $data = array_combine(array_map('strtolower',$headers), $row);
          $email = trim(strtolower($data['email'] ?? ''));
          $cat = trim(strtolower($data['category'] ?? ''));
          $score = (int)($data['score'] ?? -1);
          $source = trim($data['source'] ?? 'manual');

          if ($email==='' || $cat==='' || $score<0 || $score>100) { $skipped++; continue; }

          // find user by email
          $u = db()->prepare("SELECT id FROM users WHERE email=? LIMIT 1");
          $u->execute([$email]);
          $user = $u->fetch();
          if (!$user) { $skipped++; continue; }

          $ins = db()->prepare("INSERT INTO driver_scores (user_id,score,category,source) VALUES (?,?,?,?)");
          $ins->execute([(int)$user['id'],$score,$cat,$source]);
          $count++;
        }
        fclose($fh);
        $ok = "Imported $count rows. Skipped $skipped.";
      }
    } else { $err='Cannot open file.'; }
  } else { $err='Upload error.'; }
}

include __DIR__.'/../templates/header.php';
?>
<h1>Upload Driver Scores (CSV)</h1>
<p class="small">CSV headers must be: <code>email,category,score,source</code></p>

<?php if ($err): ?><div class="alert alert-error"><?= e($err) ?></div><?php endif; ?>
<?php if ($ok):  ?><div class="alert alert-ok"><?= e($ok) ?></div><?php endif; ?>

<form method="post" enctype="multipart/form-data" class="form-card">
  <label class="field">
    <span class="field__label">CSV file</span>
    <input class="field__input" type="file" name="csv" accept=".csv" required>
  </label>
  <div class="form__actions">
    <button class="btn btn-primary">Upload</button>
    <a class="btn btn-outline btn-small" href="?sample=1">Download CSV template</a>
  </div>
</form>

<?php
// Provide a tiny template if ?sample=1
if (isset($_GET['sample'])) {
  header('Content-Type: text/csv');
  header('Content-Disposition: attachment; filename="driver_scores_template.csv"');
  echo "email,category,score,source\n";
  echo "driver1@example.com,speeding,52,telematics\n";
  echo "driver2@example.com,fatigue,43,audit\n";
  exit;
}
?>

<?php include __DIR__.'/../templates/footer.php'; ?>
