<?php
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';
require_login();
require_ability('admin'); // or 'grade' if assessors may enroll

$user_id = (int)($_POST['user_id'] ?? 0);
$course_id = (int)($_POST['course_id'] ?? 0);
if ($user_id<=0 || $course_id<=0) { redirect('../reports/driver_analytics.php'); }

// Prevent duplicate enrollments (very simple)
$chk = db()->prepare("SELECT id FROM enrollments WHERE user_id=? AND course_id=? LIMIT 1");
$chk->execute([$user_id,$course_id]);
$exists = $chk->fetch();

if (!$exists) {
  $ins = db()->prepare("INSERT INTO enrollments (user_id, course_id, status, enrolled_at) VALUES (?,?, 'pending', NOW())");
  $ins->execute([$user_id,$course_id]);
}

redirect('../reports/driver_analytics.php');
