<?php
// admin/set_id.php — quick admin setter for learner SA ID (encrypted)
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';
require_once __DIR__.'/../lib/csrf.php';
require_once __DIR__.'/../lib/pii.php';

require_login();
if (!can('admin')) { http_response_code(403); echo "Admins only."; exit; }

$msg=''; $err='';
$uid = (int)($_GET['id'] ?? 0);

if ($_SERVER['REQUEST_METHOD']==='POST') {
  verify_csrf_or_die();
  $uid = (int)($_POST['user_id'] ?? 0);
  $id13 = trim($_POST['national_id'] ?? '');

  if ($uid<=0 || !preg_match('/^\d{13}$/',$id13)) {
    $err="Enter a valid user id and 13-digit SA ID.";
  } else {
    $enc   = pii_encrypt($id13);
    $last4 = substr($id13,-4);
    $s = db()->prepare("UPDATE users SET national_id_enc=?, national_id_last4=? WHERE id=?");
    $s->execute([$enc,$last4,$uid]);
    $msg="Saved.";
  }
}

include __DIR__.'/../templates/header.php';
?>
<h1>Admin: Set Learner SA ID</h1>
<?php if ($msg): ?><div class="alert alert-ok"><?= e($msg) ?></div><?php endif; ?>
<?php if ($err): ?><div class="alert alert-error"><?= e($err) ?></div><?php endif; ?>

<form method="post" class="form-card" style="max-width:420px;">
  <?php csrf_field(); ?>
  <label class="field">
    <span class="field__label">Learner User ID</span>
    <input class="field__input" name="user_id" type="number" value="<?= $uid ?: '' ?>" required>
  </label>
  <label class="field">
    <span class="field__label">SA ID (13 digits)</span>
    <input class="field__input" name="national_id" inputmode="numeric" pattern="\d{13}" required>
  </label>
  <div class="form__actions">
    <button class="btn btn-primary">Save</button>
    <a class="btn btn-outline" href="<?= e(url('ids_queue.php')) ?>">Back to ID Queue</a>
  </div>
</form>
<?php include __DIR__.'/../templates/footer.php'; ?>
