<?php
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/helpers.php';

require_login();
if (!can('admin')) { http_response_code(403); echo "Admins only."; exit; }

$msg=''; $err='';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $email = trim($_POST['email'] ?? '');
  $idno  = trim($_POST['id_number'] ?? '');
  if ($email === '' || $idno === '') {
    $err = 'Email and ID number are required.';
  } else {
    $st = db()->prepare("UPDATE users SET id_number=? WHERE email=?");
    $st->execute([$idno, $email]);
    if ($st->rowCount() > 0) $msg = 'Updated.';
    else $err = 'No user found with that email.';
  }
}
include __DIR__ . '/../templates/header.php';
?>
<h1>Set Learner ID Number</h1>
<?php if ($msg): ?><div class="alert alert-ok"><?= e($msg) ?></div><?php endif; ?>
<?php if ($err): ?><div class="alert alert-error"><?= e($err) ?></div><?php endif; ?>

<form method="post" class="form-card" style="max-width:520px;">
  <label class="field">
    <span class="field__label">Learner Email</span>
    <input class="field__input" name="email" placeholder="learner@example.com" required>
  </label>
  <label class="field">
    <span class="field__label">ID Number</span>
    <input class="field__input" name="id_number" placeholder="ID / Passport" required>
  </label>
  <div class="form__actions">
    <button class="btn btn-primary">Save</button>
  </div>
</form>
<?php include __DIR__ . '/../templates/footer.php'; ?>
