<?php
// admin/verify_id.php — POST only, sets national_id_verified_at=NOW()
ini_set('display_errors',1); error_reporting(E_ALL);

require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/helpers.php';
require_once __DIR__ . '/../lib/csrf.php';

require_login();
if (!can('admin')) { http_response_code(403); echo "Admins only."; exit; }
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { http_response_code(405); echo "POST only."; exit; }

verify_csrf_or_die();

$uid = (int)($_POST['user_id'] ?? 0);
if ($uid <= 0) { http_response_code(400); echo "Bad request."; exit; }

// only verify if the learner actually has an ID on file
$st = db()->prepare("SELECT national_id_enc FROM users WHERE id=? AND role='learner' LIMIT 1");
$st->execute([$uid]);
$u = $st->fetch();
if (!$u || empty($u['national_id_enc'])) {
  http_response_code(400);
  echo "User not found or no ID captured.";
  exit;
}

$up = db()->prepare("UPDATE users SET national_id_verified_at=NOW() WHERE id=?");
$up->execute([$uid]);

// old:
// redirect('../admin/ids_queue.php');
// new (absolute):
redirect(url('admin/ids_queue.php'));
