<?php
require_once __DIR__ . '/lib/auth.php'; require_once __DIR__ . '/lib/helpers.php'; require_once __DIR__ . '/lib/ai.php';
require_once __DIR__ . '/lib/db.php'; require_once __DIR__ . '/lib/policy.php'; require_login(); require_ability('grade');
require_once __DIR__ . '/lib/demo.php';
demo_guard(); // blocks POST in demo mode

include __DIR__ . '/templates/header.php';

$msg=''; $raw=''; $draft='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $sub_id=(int)($_POST['submission_id']??0);
  $row=db()->prepare("SELECT s.*,u.name learner,c.title course FROM submissions s
                      LEFT JOIN users u ON u.id=s.user_id LEFT JOIN courses c ON c.id=s.course_id
                      WHERE s.id=?");
  $row->execute([$sub_id]); $row=$row->fetch();
  if($row){
    // Read file text (simple: treat as text; for PDF you’d add a parser)
    $path=__DIR__ . '/../storage/poes/' . $row['filename'];
    $raw = @file_get_contents($path);
    if(!$raw) $raw = "(Could not read file; please paste text manually.)";
    $rubric = "Criteria: Safety rules applied; Procedure accuracy; Evidence completeness; Presentation clarity; Reflection.";
    $messages=[
      ['role'=>'system','content'=>ai_system_prompt()."\nYou are drafting assessor feedback. Output short, structured notes with improvement tips. Never assign a final mark; that is for the assessor."],
      ['role'=>'user','content'=>"Course: ".$row['course']."\nLearner: ".$row['learner']."\nRubric: ".$rubric."\nSubmission excerpt:\n".$raw]
    ];
    $res=llm_chat($messages,false); $draft=$res['text'] ?? '';
  } else $msg="Submission not found.";
}
$subs=db()->query("SELECT s.id, u.name learner, c.title course, s.filename FROM submissions s
                   LEFT JOIN users u ON u.id=s.user_id LEFT JOIN courses c ON c.id=s.course_id
                   ORDER BY s.id DESC")->fetchAll();
?>
<h2>AI Draft Feedback (assessor approves)</h2>
<form method="post">
  <label>Choose submission:
    <select name="submission_id" required>
      <?php foreach($subs as $s): ?>
        <option value="<?=$s['id']?>">#<?=$s['id']?> — <?=e($s['learner'])?> — <?=e($s['course'])?> — <?=e($s['filename'])?></option>
      <?php endforeach; ?>
    </select>
  </label>
  <button type="submit">Generate draft feedback</button>
</form>
<?php if($draft): ?>
  <h3>AI Draft</h3><div style="white-space:pre-wrap;"><?=e($draft)?></div>
  <p><em>Now you (human assessor) adjust and record grade in your usual process.</em></p>
<?php endif; if($msg) echo "<p>".e($msg)."</p>"; include __DIR__ . '/templates/footer.php'; ?>
