<?php
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/helpers.php';
header('Content-Type: application/json');

if (!is_logged_in()) { http_response_code(401); echo json_encode(['ok'=>false,'msg'=>'auth']); exit; }

$uid = current_user_id();
$course_id = (int)($_POST['course_id'] ?? 0);
$module_id = ($_POST['module_id'] === '' ? null : (int)($_POST['module_id'] ?? 0));
$lesson_id = ($_POST['lesson_id'] === '' ? null : (int)($_POST['lesson_id'] ?? 0));
$progress  = max(0, min(100, (int)($_POST['progress_pct'] ?? 0)));
$position  = (int)($_POST['last_position_sec'] ?? 0);
$last_page = trim($_POST['last_page'] ?? '');

if ($course_id <= 0) { echo json_encode(['ok'=>false,'msg'=>'no course']); exit; }

$s = db()->prepare("INSERT INTO learner_progress (user_id,course_id,module_id,lesson_id,progress_pct,last_position_sec,last_page)
VALUES (?,?,?,?,?,?,?)
ON DUPLICATE KEY UPDATE progress_pct=VALUES(progress_pct), last_position_sec=VALUES(last_position_sec),
last_page=VALUES(last_page), last_saved_at=CURRENT_TIMESTAMP");
$s->execute([$uid,$course_id,$module_id,$lesson_id,$progress,$position,$last_page]);

-- update enrollment roll-up
$q = db()->prepare("UPDATE enrollments SET progress_pct=?, last_activity=NOW() WHERE user_id=? AND course_id=?");
$q->execute([$progress, $uid, $course_id]);

echo json_encode(['ok'=>true]);
