<?php
require_once __DIR__ . '/bootstrap_dev.php';

function say($ok, $msg){
  echo $ok ? "✅ $msg<br>" : "❌ $msg<br>";
}

echo "<h2>AIT LMIS — Health Check</h2>";

$paths = [
  'lib/config.php', 'lib/db.php', 'lib/helpers.php', 'lib/auth.php',
  'templates/header.php', 'templates/footer.php'
];
foreach ($paths as $p){
  say(file_exists(__DIR__."/$p"), "File present: $p");
}

// load config + db
require_once __DIR__ . '/lib/config.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';
require_once __DIR__ . '/lib/auth.php';

// DB connect
try {
  $pdo = db();
  say(true, "Database connected");
} catch (Throwable $e){
  say(false, "Database connect failed: ".$e->getMessage());
  exit; // stop here if DB is down
}

// tables
$tables = ['users','courses','submissions','enrollments','results','certificates'];
foreach ($tables as $t){
  try {
    $pdo->query("SELECT 1 FROM `$t` LIMIT 1");
    say(true, "Table exists: $t");
  } catch(Throwable $e){
    say(false, "Table missing or unreadable: $t (".$e->getMessage().")");
  }
}

// columns often used
function has_col($t,$c){
  global $pdo;
  try {
    $st = $pdo->prepare("SHOW COLUMNS FROM `$t` LIKE ?");
    $st->execute([$c]);
    return (bool)$st->fetch();
  } catch(Throwable $e){ return false; }
}

if (has_col('submissions','status')){
  say(true, "submissions.status exists");
} else {
  say(false, "submissions.status missing (not fatal)");
}
if (has_col('results','verified_at')){
  say(true, "results.verified_at exists");
} else {
  say(false, "results.verified_at missing (not fatal)");
}
if (has_col('results','moderated_at')){
  say(true, "results.moderated_at exists");
} else {
  say(false, "results.moderated_at missing (not fatal)");
}

// storage folders
$certDir = __DIR__ . '/storage/uploads/certs';
say(is_dir($certDir), "Folder exists: storage/uploads/certs");
say(is_writable($certDir), "Folder writable: storage/uploads/certs");

// dompdf vendor
$vendor = __DIR__ . '/vendor/autoload.php';
say(file_exists($vendor), "Dompdf autoload present: vendor/autoload.php");

echo "<hr><p>Open a problem page and put this at the top while debugging:<br><code>&lt;?php require_once __DIR__ . '/bootstrap_dev.php';</code></p>";
