<?php
// Put this at the VERY TOP of any page while debugging
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

// nice fatal error catcher (so you see the message)
set_exception_handler(function($e){
  http_response_code(500);
  echo "<pre style='white-space:pre-wrap;background:#fff;border:1px solid #f00;padding:10px'>";
  echo "🔥 PHP Error: " . htmlspecialchars($e->getMessage()) . "\n\n";
  echo "File: " . $e->getFile() . " : " . $e->getLine() . "\n\n";
  echo htmlspecialchars($e->getTraceAsString());
  echo "</pre>";
  exit;
});
set_error_handler(function($errno,$errstr,$errfile,$errline){
  throw new ErrorException($errstr, 0, $errno, $errfile, $errline);
});
