<?php
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/policy.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';
require_login(); require_ability('grade');
require_once __DIR__ . '/lib/demo.php';
demo_guard(); // blocks POST in demo mode


$msg='';

// Load dropdowns
$users=db()->query("SELECT id,name FROM users WHERE role='learner' ORDER BY name")->fetchAll();
$courses=db()->query("SELECT id,title,expiry_months FROM courses ORDER BY title")->fetchAll();

// Handle POST
if($_SERVER['REQUEST_METHOD']==='POST'){
  $user_id=(int)$_POST['user_id'];
  $course_id=(int)$_POST['course_id'];
  $start = $_POST['course_start'] ?: null;
  $end   = $_POST['course_end'] ?: null;

  // get expiry months
  $c = db()->prepare("SELECT expiry_months FROM courses WHERE id=?");
  $c->execute([$course_id]); $crs=$c->fetch();
  $months = (int)($crs['expiry_months'] ?? 36);

  // create code + hash
  $code = 'C'.bin2hex(random_bytes(4));
  $secret = 'CHANGE_ME_SALT';
  $data = $user_id.'|'.$course_id.'|'.date('Y-m-d H:i:s').'|'.$secret;
  $hash = hash('sha256',$data);

  // compute expiry date (from end date if provided, else issued_at + months)
  $issued_at = date('Y-m-d');
  $baseDate = $end ?: $issued_at;
  $expiry_date = date('Y-m-d', strtotime($baseDate." +$months months"));

  // assessor is the current user
  $assessor_id = current_user()['id'];

  $ins = db()->prepare("
    INSERT INTO certificates(user_id,course_id,cert_code,cert_hash,issued_at,assessor_id,course_start,course_end,expiry_date)
    VALUES (?,?,?,?,NOW(),?,?,?,?)
  ");
  $ins->execute([$user_id,$course_id,$code,$hash,$assessor_id,$start,$end,$expiry_date]);

  $msg="Issued certificate: $code (expiry $expiry_date)";
}

?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Issue Certificate</title>
<link rel="stylesheet" href="<?= e(url('assets/css/style.css')) ?>">
</head><body>
<?php include __DIR__ . '/templates/header.php'; ?>
<h2>Issue Certificate</h2>
<?php if($msg): ?><p style="color:green"><?=e($msg)?></p><?php endif; ?>
<form method="post">
  <label>Learner:
    <select name="user_id" required>
      <?php foreach($users as $u): ?><option value="<?=$u['id']?>"><?=e($u['name'])?></option><?php endforeach; ?>
    </select>
  </label><br>
  <label>Course:
    <select name="course_id" required>
      <?php foreach($courses as $c): ?><option value="<?=$c['id']?>"><?=e($c['title'])?></option><?php endforeach; ?>
    </select>
  </label><br>
  <label>Course start date: <input type="date" name="course_start"></label><br>
  <label>Course end date: <input type="date" name="course_end"></label><br>
  <button class="btn">Issue</button>
</form>
<p>After issuing, open <em>Certificates</em> to view/print and verify.</p>
<?php include __DIR__ . '/templates/footer.php'; ?>
</body></html>
