<?php
// certificate_template.php — builds $html from $cert for Dompdf + browser preview

// helpers
function has_table($t){ try{ db()->query("SELECT 1 FROM `$t` LIMIT 1"); return true; } catch(Throwable $e){ return false; } }
function qv($sql,$p=[]){ $s=db()->prepare($sql); $s->execute($p); return $s->fetch(); }

// pull linked user/course
$user = has_table('users') ? qv("SELECT id,name,email,role,IFNULL(id_number,'') id_number FROM users WHERE id=? LIMIT 1", [(int)($cert['user_id'] ?? 0)]) : null;
$course= has_table('courses') ? qv("SELECT id,title,
                                       IFNULL(nqf_level,'') nqf_level,
                                       IFNULL(credits,'') credits,
                                       IFNULL(course_number,'') course_number,
                                       IFNULL(unit_standard_no,'') unit_standard_no
                                   FROM courses WHERE id=? LIMIT 1", [(int)($cert['course_id'] ?? 0)]) : null;

require_once __DIR__ . '/lib/settings.php';

// provider from settings (with safe defaults)
$provName   = setting('provider_name',      'Accredited Provider');
$provAddr   = setting('provider_address',   '');
$provAccred = setting('provider_accred_no', '');
$logo1      = setting('provider_logo_url',  full_url('assets/img/ait_logo.png'));
$logo2      = setting('provider_logo2_url', full_url('assets/img/teta_logo.png'));


// fields from certificate record (with sensible fallbacks)
$code         = $cert['code'] ?? ($cert['cert_code'] ?? '');
$serial       = $cert['serial'] ?? ($cert['number'] ?? '');
$issued_at    = $cert['issued_at'] ?? date('Y-m-d');
$expiry       = $cert['expiry_date'] ?? '';
$actReg       = $cert['act_regulation'] ?? '';
$hash_hex     = $cert['hash'] ?? ($cert['hash_sha256'] ?? '');

$machineCode  = $cert['machine_code'] ?? '';
$machineDesc  = $cert['machine_desc'] ?? '';
$attachments  = $cert['machine_attachments'] ?? '';
$capacity     = $cert['machine_capacity'] ?? '';
$restrictions = $cert['restrictions'] ?? '';

$assessorReg  = $cert['assessor_reg_no'] ?? '';
$assessorName = $cert['assessor'] ?? '';         // from your earlier model
$assessorNo   = $cert['assessor_no'] ?? '';

$principal    = $cert['principal'] ?? '';
$principalNo  = $cert['principal_no'] ?? '';

// unit standard and credits → from cert, else from course
$unitStdNo    = $cert['unit_standard_no'] ?? ($course['unit_standard_no'] ?? '');
$creditVal    = $cert['unit_credit_value'] ?? ($course['credits'] ?? '');

// learner info
$learnerName  = $user['name'] ?? 'Learner';
$learnerEmail = $user['email'] ?? '';
$learnerIDNo  = $user['id_number'] ?? '';

// course info
$courseTitle  = $course['title'] ?? 'Course';
$nqfLevel     = $course['nqf_level'] ?? '';
$courseNo     = $course['course_number'] ?? '';

// signatures (at least two)
$sign1_name   = $cert['sign1_name']  ?? ($assessorName ?: 'Authorised Signatory 1');
$sign1_title  = $cert['sign1_title'] ?? 'Assessor';
$sign1_img    = $cert['sign1_img']   ?? '';  // e.g., assets/img/sign1.png (full URL is best)

$sign2_name   = $cert['sign2_name']  ?? ($principal ?: 'Authorised Signatory 2');
$sign2_title  = $cert['sign2_title'] ?? 'Principal';
$sign2_img    = $cert['sign2_img']   ?? '';  // e.g., assets/img/sign2.png

// URLs
$verifyUrl = full_url('verify.php?code='.rawurlencode($code));

// Build HTML
ob_start();
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Certificate <?= e($code) ?></title>
<style>
  @page { size: A4 landscape; margin: 16mm; }
  body { font-family: DejaVu Sans, Arial, Helvetica, sans-serif; color:#111; }

  .brand { display:flex; justify-content: space-between; align-items:center; }
  .brand .logos img { height:56px; background:#fff; padding:6px; border-radius:8px; box-shadow: 0 2px 4px rgba(0,0,0,.12); margin-left:8px; }

  .title { text-align:center; margin:12px 0 4px 0; font-size:28px; font-weight:700; letter-spacing:.4px; }
  .subtitle { text-align:center; margin:0 0 12px 0; color:#333; }

  .provider { border:1.5px solid #0f4aa8; border-radius:12px; padding:10px 12px; margin-bottom:12px; }
  .label { color:#555; font-size:12px; text-transform:uppercase; letter-spacing:.6px; }
  .value { font-size:16px; font-weight:700; }

  .grid2 { display: table; width: 100%; table-layout: fixed; }
  .col { display: table-cell; vertical-align: top; padding: 6px 10px; }

  .panel { border:1px solid #e5e7eb; border-radius:10px; padding:10px 12px; margin-top:10px; }
  .row { display:flex; gap:16px; }
  .cell { flex:1; }
  .muted { color:#666; }

  .sign-wrap { display:flex; gap:18px; margin-top:16px; }
  .sign { flex:1; text-align:center; }
  .sign-img { height:46px; margin-bottom:6px; }
  .sign-line { border-top:1px solid #999; padding-top:4px; }
  .foot { margin-top: 12px; font-size: 12px; color:#333; display:flex; justify-content: space-between; }

  .watermark {
    position: fixed; top: 36%; left: 10%; right:10%; text-align: center;
    font-size: 80px; color: rgba(0,0,0,0.04); transform: rotate(-15deg); z-index: 0;
  }

  .mono { font-family: "DejaVu Sans Mono", monospace; font-size:12px; }
</style>
</head>
<body>

<div class="brand">
  <div>
    <div class="label">Accredited Provider</div>
    <div class="value"><?= e($provName) ?></div>
  </div>
  <div class="logos">
    <img src="<?= e($logo1) ?>" alt="Provider">
    <img src="<?= e($logo2) ?>" alt="Authority">
  </div>
</div>

<div class="provider">
  <div class="grid2">
    <div class="col">
      <div class="label">Provider Address</div>
      <div><?= e($provAddr) ?></div>
    </div>
    <div class="col">
      <div class="label">Accreditation Number</div>
      <div class="value"><?= e($provAccred) ?></div>
    </div>
  </div>
</div>

<h1 class="title">Certificate of Competence</h1>
<p class="subtitle">Issued in accordance with <?= e($actReg ?: 'applicable Acts and Regulations') ?>.</p>

<div class="panel">
  <div class="row">
    <div class="cell">
      <div class="label">Learner</div>
      <div class="value"><?= e($learnerName) ?></div>
    </div>
    <div class="cell">
      <div class="label">Learner Identification Number</div>
      <div><?= e($learnerIDNo ?: '—') ?></div>
    </div>
    <div class="cell">
      <div class="label">Certificate ID / Serial</div>
      <div class="mono"><?= e($serial ?: $code) ?></div>
    </div>
  </div>

  <div class="row" style="margin-top:8px;">
    <div class="cell">
      <div class="label">Course</div>
      <div class="value"><?= e($courseTitle) ?></div>
      <div class="muted"><?= e($nqfLevel ? "NQF: ".$nqfLevel : '') ?><?= $courseNo ? " • ".e($courseNo) : '' ?></div>
    </div>
    <div class="cell">
      <div class="label">Unit Standard</div>
      <div><?= e($unitStdNo ?: '—') ?><?= $creditVal ? " • Credits: ".e($creditVal) : '' ?></div>
    </div>
    <div class="cell">
      <div class="label">Assessor Registration No.</div>
      <div><?= e($assessorReg ?: $assessorNo ?: '—') ?></div>
    </div>
  </div>

  <div class="row" style="margin-top:8px;">
    <div class="cell">
      <div class="label">Lifting Machine Code</div>
      <div><?= e($machineCode ?: '—') ?></div>
    </div>
    <div class="cell">
      <div class="label">Code Description / Attachments</div>
      <div><?= e($machineDesc) ?><?= $attachments ? " • ".e($attachments) : '' ?></div>
    </div>
    <div class="cell">
      <div class="label">Capacity</div>
      <div><?= e($capacity ?: '—') ?></div>
    </div>
  </div>

  <div class="row" style="margin-top:8px;">
    <div class="cell">
      <div class="label">Restrictions of Operation</div>
      <div><?= e($restrictions ?: 'None') ?></div>
    </div>
    <div class="cell">
      <div class="label">Issue Date</div>
      <div><?= e($issued_at) ?></div>
    </div>
    <div class="cell">
      <div class="label">Expiry Date</div>
      <div><?= e($expiry ?: 'N/A') ?></div>
    </div>
  </div>
</div>

<div class="sign-wrap">
  <div class="sign">
    <?php if ($sign1_img): ?><img class="sign-img" src="<?= e(full_url($sign1_img)) ?>" alt="Sign 1"><?php endif; ?>
    <div class="sign-line"><?= e($sign1_name) ?><br><span class="muted"><?= e($sign1_title) ?></span></div>
  </div>
  <div class="sign">
    <?php if ($sign2_img): ?><img class="sign-img" src="<?= e(full_url($sign2_img)) ?>" alt="Sign 2"><?php endif; ?>
    <div class="sign-line"><?= e($sign2_name) ?><br><span class="muted"><?= e($sign2_title) ?></span></div>
  </div>
</div>

<div class="watermark">AFRICA IN TRAINING</div>

<div class="panel" style="margin-top:12px;">
  <div class="row">
    <div class="cell">
      <div class="label">Verify</div>
      <div class="mono"><?= e($verifyUrl) ?></div>
    </div>
    <div class="cell">
      <div class="label">Certificate Code (hash)</div>
      <div class="mono" style="word-break:break-all;"><?= e($hash_hex ?: '—') ?></div>
    </div>
    <div class="cell" style="text-align:right;">
      <img src="https://api.qrserver.com/v1/create-qr-code/?size=120x120&data=<?= rawurlencode($verifyUrl) ?>" alt="QR">
    </div>
  </div>
</div>

<div class="foot">
  <div><?= e($provName) ?> • <?= e($provAddr) ?></div>
  <div>Accreditation No: <?= e($provAccred) ?></div>
</div>

</body>
</html>
<?php
$html = ob_get_clean();
