<?php require_once __DIR__ . '/bootstrap_dev.php';

require_once __DIR__ . '/lib/auth.php';
require_login();
$me = current_user();

if ($me['role'] === 'learner') {
  // force filter to my own certs
  $q = trim($_GET['q'] ?? '');
  $st = db()->prepare("
    SELECT c.*, co.title course
    FROM certificates c
    JOIN courses co ON co.id=c.course_id
    WHERE c.user_id=?
    ORDER BY c.issued_at DESC LIMIT 200
  ");
  $st->execute([$me['id']]);
  $rows = $st->fetchAll();
  // render as usual...
  // (and consider hiding admin-only actions like Save PDF)
  // exit; (or wrap the rest in role checks)
}

require_once __DIR__ . '/lib/policy.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';
require_login();
require_ability('report');

$q = trim($_GET['q'] ?? '');
$sql = "SELECT c.*, u.name learner, u.email, co.title course
        FROM certificates c
        LEFT JOIN users u ON u.id=c.user_id
        LEFT JOIN courses co ON co.id=c.course_id ";
$params = [];
if ($q !== ''){
  $sql .= "WHERE c.cert_code LIKE ? OR u.name LIKE ? OR u.email LIKE ? OR co.title LIKE ? ";
  $like = '%'.$q.'%';
  $params = [$like,$like,$like,$like];
}
$sql .= "ORDER BY c.issued_at DESC LIMIT 200";

$st = db()->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Certificates</title>
<style>
table{border-collapse:collapse;width:100%}td,th{border:1px solid #ccc;padding:6px}
.actions form{display:inline}
</style>
</head>
<body>
<?php include __DIR__ . '/templates/header.php'; ?>
<h2>Certificates (Search, Reprint, Save Copies)</h2>
<form method="get">
  <input name="q" placeholder="name, email, course, code" value="<?=e($q)?>">
  <button>Search</button>
</form>
<table>
  <tr>
    <th>Code</th><th>Learner</th><th>Email</th><th>Course</th><th>Issued</th><th>Actions</th><th>Saved PDF</th>
  </tr>
  <?php foreach($rows as $r): ?>
  <tr>
    <td><?=e($r['cert_code'])?></td>
    <td><?=e($r['learner'])?></td>
    <td><?=e($r['email'])?></td>
    <td><?=e($r['course'])?></td>
    <td><?=e($r['issued_at'])?></td>
    <td class="actions">
      <a href="<?=url('certificate_view.php?code='.urlencode($r['cert_code']))?>">View</a> |
      <a href="<?=url('certificate_pdf.php?code='.urlencode($r['cert_code']))?>">PDF</a> |
      <a href="<?=url('verify.php?code='.urlencode($r['cert_code']))?>" target="_blank">Verify</a>
    </td>
    <td>
      <?php if(!empty($r['pdf_path']) && file_exists(__DIR__ . '/'.$r['pdf_path'])): ?>
        <a href="<?=e($r['pdf_path'])?>" target="_blank">Open Saved</a>
      <?php else: ?>
        <form method="post" action="certificate_save_pdf.php">
          <input type="hidden" name="code" value="<?=e($r['cert_code'])?>">
          <button>Save PDF Copy</button>
        </form>
      <?php endif; ?>
    </td>
  </tr>
  <?php endforeach; ?>
</table>
<?php include __DIR__ . '/templates/footer.php'; ?>
</body>
</html>
