<?php
// Renders the same HTML as view, but via Dompdf (A4 portrait)
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__.'/lib/db.php';
require_once __DIR__.'/lib/helpers.php';
require_once __DIR__.'/lib/settings.php';
require_once __DIR__.'/lib/pii.php';

$code = trim($_GET['code'] ?? '');
if ($code === '') { http_response_code(400); echo "Missing code."; exit; }

// Load data
$st = db()->prepare("SELECT * FROM certificates WHERE cert_code=? LIMIT 1");
$st->execute([$code]);
$CERT = $st->fetch();
if (!$CERT) { http_response_code(404); echo "Certificate not found."; exit; }

$st = db()->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
$st->execute([$CERT['user_id']]);
$LEARN = $st->fetch() ?: [];

$st = db()->prepare("SELECT * FROM courses WHERE id=? LIMIT 1");
$st->execute([$CERT['course_id']]);
$COURSE = $st->fetch() ?: [];

// Enforce 13-digit ID (decrypt if present)
$learner_id = '';
try {
  if (!empty($LEARN['national_id_enc'])) {
    $learner_id = pii_decrypt($LEARN['national_id_enc']);
  }
} catch (Throwable $e) {}
if (!preg_match('/^\d{13}$/', (string)$learner_id)) {
  http_response_code(400);
  echo "Certificate blocked — learner SA ID missing. Please capture it on profile.";
  exit;
}

// Render HTML using the same template
$for_pdf = true;
ob_start();
$tfile = __DIR__ . '/templates/certificate_render.php';
if (!is_file($tfile)) { echo "Missing template: templates/certificate_render.php"; exit; }
include $tfile;
$html = ob_get_clean();

// Dompdf
require_once __DIR__.'/vendor/autoload.php';
use Dompdf\Dompdf; use Dompdf\Options;
$opts = new Options();
$opts->set('isRemoteEnabled', true);
$opts->set('isHtml5ParserEnabled', true);
$opts->set('defaultFont', 'DejaVu Sans');
$opts->setChroot(__DIR__); // keep resources inside /lmis
$dompdf = new Dompdf($opts);
$dompdf->setPaper('A4','portrait');
$dompdf->loadHtml($html,'UTF-8');
$dompdf->render();

// Stream
$filename = 'certificate-'.preg_replace('~[^A-Za-z0-9_-]+~','',$code).'.pdf';
$dompdf->stream($filename, ['Attachment'=>0]);
