<?php
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';
require_once __DIR__.'/../lib/csrf.php';

require_login();
if (!can('company')) { http_response_code(403); echo "Company reps only."; exit; }
$u = current_user(); $cid = (int)($u['company_id'] ?? 0);
if ($cid <= 0) { http_response_code(400); echo "No company linked."; exit; }

$filterUser = (int)($_GET['user_id'] ?? 0);

// fetch certs for this company (optionally for a single user)
$params = [$cid];
$sql = "
  SELECT c.cert_code, c.pdf_path, u.name AS learner, co.title AS course
  FROM certificates c
  JOIN users u ON u.id=c.user_id
  LEFT JOIN courses co ON co.id=c.course_id
  WHERE u.company_id=?
";
if ($filterUser > 0) { $sql .= " AND u.id=?"; $params[] = $filterUser; }
$sql .= " ORDER BY c.id DESC";

$st = db()->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();
if (!$rows) { echo "No certificates."; exit; }

// Use ZipArchive
$zip = new ZipArchive();
$tmp = tempnam(sys_get_temp_dir(), 'certs_zip_');
$zip->open($tmp, ZipArchive::OVERWRITE);

// Try to include each cert: if no saved PDF, fall back to live generation URL as a stub link
foreach ($rows as $r) {
  $safeCode = preg_replace('~[^A-Za-z0-9_-]+~','',$r['cert_code']);
  $fname = ($safeCode ?: 'cert').'.pdf';

  $abs = null;
  if (!empty($r['pdf_path'])) {
    // pdf_path is web path like /storage/certs/xxx.pdf; convert to absolute
    $abs = realpath(__DIR__.'/..'.$r['pdf_path']);
  }
  if ($abs && is_readable($abs)) {
    $zip->addFile($abs, $fname);
  } else {
    // add a text placeholder if PDF not saved yet
    $msg = "PDF not saved. Open and Save first: ".full_url('certificate_pdf.php?code='.urlencode($r['cert_code']));
    $zip->addFromString($safeCode.'_README.txt', $msg);
  }
}
$zip->close();

// stream zip
$filename = 'company_certs_'.date('Ymd_His').'.zip';
header('Content-Type: application/zip');
header('Content-Length: '.filesize($tmp));
header('Content-Disposition: attachment; filename="'.$filename.'"');
readfile($tmp);
@unlink($tmp);
