<?php
// /lmis/company/create.php
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/helpers.php';
require_once __DIR__ . '/../lib/csrf.php';

require_login();
$u = current_user();

$msg=''; $err='';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  verify_csrf_or_die();
  $name   = trim($_POST['name'] ?? '');
  $reg_no = trim($_POST['reg_no'] ?? '');
  if ($name==='') { $err='Company name is required.'; }

  if (!$err) {
    // create company
    $ins = db()->prepare("INSERT INTO companies(name, reg_no, created_by) VALUES(?,?,?)");
    $ins->execute([$name, $reg_no, $u['id']]);
    $company_id = (int)db()->lastInsertId();

    // map current user as company_rep
    $map = db()->prepare("INSERT INTO company_user_map(company_id,user_id,role) VALUES(?,?, 'company_rep')");
    $map->execute([$company_id, $u['id']]);

    redirect('settings.php');
  }
}

include __DIR__ . '/../templates/header.php';
?>
<h1>Create Company</h1>
<?php if ($err): ?><div class="alert alert-error"><?= e($err) ?></div><?php endif; ?>
<form method="post" class="form-card" style="max-width:520px;">
  <?php csrf_field(); ?>
  <label class="field">
    <span class="field__label">Company name</span>
    <input class="field__input" name="name" placeholder="e.g. Super Logistics (Pty) Ltd" required>
  </label>
  <label class="field">
    <span class="field__label">Registration no (optional)</span>
    <input class="field__input" name="reg_no" placeholder="e.g. 2019/123456/07">
  </label>
  <div class="form__actions">
    <button class="btn btn-primary">Create</button>
    <a class="btn btn-outline" href="<?= e(url('company/')) ?>">Cancel</a>
  </div>
</form>
<?php include __DIR__ . '/../templates/footer.php'; ?>
