<?php
$rows = db()->query("
  SELECT u.id, u.name, u.email,
         (SELECT ds.score FROM driver_scores ds WHERE ds.user_id=u.id AND ds.category='weekly' ORDER BY ds.recorded_at DESC LIMIT 1) AS latest_score
    FROM users u
   WHERE u.company_id IS NOT NULL
   ORDER BY u.name
   LIMIT 100
")->fetchAll();

$myCourses = db()->prepare("
  SELECT c.id, c.title, e.status
  FROM enrollments e
  JOIN courses c ON c.id=e.course_id
  WHERE e.user_id=? 
  ORDER BY c.title
");
$myCourses->execute([$u['id']]);
$myCourses = $myCourses->fetchAll();


$low = array_filter($rows, fn($r)=> (int)($r['latest_score']??0) < 60);
?>
<section class="panel">
  <h2 class="panel__title">Drivers needing attention</h2>
  <div class="panel__body">
    <?php if (!$low): ?>
      <p class="small muted">No drivers below threshold this week.</p>
    <?php else: ?>
      <table class="mini">
        <tr><th>Driver</th><th>Email</th><th>Score</th><th>Recommend</th></tr>
        <?php foreach ($low as $r):
          $rec = recommended_course_for_score((int)$r['latest_score']);
        ?>
          <tr>
            <td><?= e($r['name']) ?></td>
            <td><?= e($r['email']) ?></td>
            <td><strong><?= (int)$r['latest_score'] ?></strong></td>
            <td>
              <?php if ($rec): ?>
                <a class="btn btn-small" href="<?= e(url('course_view.php?id='.$rec['course_id'])) ?>">Open: <?= e($rec['title']) ?></a>
              <?php else: ?>
                <span class="small muted">—</span>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
      </table>
    <?php endif; ?>
  </div>
</section>
