<?php
// /lmis/company/index.php
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/helpers.php';

require_login();
$u = current_user();

// find a company linked to me
$st = db()->prepare("
  SELECT c.id, c.name
  FROM company_user_map m
  JOIN companies c ON c.id=m.company_id
  WHERE m.user_id=? LIMIT 1
");
$st->execute([$u['id']]);
$myco = $st->fetch();

if ($myco) {
  // I already belong to a company → go to settings
  redirect('settings.php');
}

include __DIR__ . '/../templates/header.php';
?>
<h1>Company</h1>
<p>You don’t have a company yet.</p>
<p>
  <a class="btn btn-primary" href="create.php">Create my company</a>
</p>
<?php include __DIR__ . '/../templates/footer.php'; ?>
