<?php
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';

require_login();
if (!can('company')) { http_response_code(403); echo "Company reps only."; exit; }
$u = current_user(); $cid = (int)($u['company_id'] ?? 0);
if ($cid <= 0) { http_response_code(400); echo "No company linked."; exit; }

$viewId = (int)($_GET['id'] ?? 0);

include __DIR__.'/../templates/header.php';

if ($viewId > 0) {
  $inv = db()->prepare("SELECT * FROM invoices WHERE id=? AND company_id=? LIMIT 1");
  $inv->execute([$viewId,$cid]);
  $i = $inv->fetch();
  if (!$i) { echo "<p>Invoice not found.</p>"; include __DIR__.'/../templates/footer.php'; exit; }

  $it = db()->prepare("SELECT * FROM invoice_items WHERE invoice_id=?");
  $it->execute([$viewId]);
  $items = $it->fetchAll();

  echo "<h1>Invoice ".$i['invoice_no']."</h1>";
  echo "<p class='small'>Period: ".e($i['period_start'])." to ".e($i['period_end'])." — Status: ".e($i['status'])."</p>";
  echo "<table class='mini'><tr><th>Description</th><th>Qty</th><th>Unit</th><th>Total</th></tr>";
  foreach ($items as $L) {
    echo "<tr>
      <td>".e($L['description'])."</td>
      <td>".(int)$L['qty']."</td>
      <td>R ".number_format($L['unit_cents']/100,2)."</td>
      <td>R ".number_format($L['line_cents']/100,2)."</td>
    </tr>";
  }
  echo "<tr><th colspan='3' style='text-align:right'>Grand Total</th><th>R ".number_format($i['total_cents']/100,2)."</th></tr>";
  echo "</table>";
  echo "<p><a class='btn btn-outline' href='".e(url('company/invoices.php'))."'>Back</a></p>";
} else {
  $rows = db()->prepare("SELECT * FROM invoices WHERE company_id=? ORDER BY id DESC");
  $rows->execute([$cid]);
  $list = $rows->fetchAll();

  echo "<h1>Invoices</h1>";
  echo "<p><a class='btn' href='".e(url('company/invoices_generate.php'))."'>Generate current month</a></p>";
  echo "<table class='mini'><tr><th>No</th><th>Period</th><th>Total</th><th>Status</th><th></th></tr>";
  foreach ($list as $i) {
    echo "<tr>
      <td>".e($i['invoice_no'])."</td>
      <td>".e($i['period_start'])." → ".e($i['period_end'])."</td>
      <td>R ".number_format($i['total_cents']/100,2)."</td>
      <td>".e($i['status'])."</td>
      <td><a class='btn btn-small' href='".e(url('company/invoices.php?id='.(int)$i['id']))."'>Open</a></td>
    </tr>";
  }
  echo "</table>";
}

include __DIR__.'/../templates/footer.php';
