<?php
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';

require_login();
if (!can('company')) { http_response_code(403); echo "Company reps only."; exit; }

$u = current_user(); $cid = (int)($u['company_id'] ?? 0);
if ($cid <= 0) { http_response_code(400); echo "No company linked."; exit; }

// current month window
$start = date('Y-m-01');
$end   = date('Y-m-t');

// prevent duplicate invoice for same period
$ck = db()->prepare("SELECT id FROM invoices WHERE company_id=? AND period_start=? AND period_end=? LIMIT 1");
$ck->execute([$cid,$start,$end]);
if ($ck->fetch()) { echo "Invoice for this month already exists."; exit; }

// collect enrollments this month (if you have enrollments table)
$enrs = [];
try {
  $st = db()->prepare("
    SELECT e.user_id, e.course_id, u.name AS learner, c.title AS course, c.price
      FROM enrollments e
      JOIN users u ON u.id=e.user_id
      JOIN courses c ON c.id=e.course_id
     WHERE u.company_id=? AND DATE(e.created_at) BETWEEN ? AND ?
     ORDER BY e.id ASC
  ");
  $st->execute([$cid,$start,$end]);
  $enrs = $st->fetchAll();
} catch(Throwable $e) {
  echo "No enrollments table or error. Cannot generate."; exit;
}
if (!$enrs) { echo "No enrollments this month."; exit; }

// create invoice
db()->beginTransaction();
try {
  // next invoice number (very simple)
  $invNo = 'INV-'.date('Ym').'-'.$cid.'-'.substr(md5(uniqid('',true)),0,6);
  $ins = db()->prepare("INSERT INTO invoices(company_id, invoice_no, period_start, period_end, total_cents, status) VALUES(?,?,?,?,0,'draft')");
  $ins->execute([$cid,$invNo,$start,$end]);
  $invId = db()->lastInsertId();

  $total = 0;
  foreach ($enrs as $r) {
    // find price: company override > course price > 0
    $price_cents = 0;
    $ov = db()->prepare("SELECT price_cents FROM company_course_prices WHERE company_id=? AND course_id=? LIMIT 1");
    $ov->execute([$cid,$r['course_id']]);
    if ($x = $ov->fetch()) {
      $price_cents = (int)$x['price_cents'];
    } else {
      $course_price = $r['price'] ?? 0;
      $price_cents = (int)round(((float)$course_price) * 100);
    }

    $desc = 'Enrollment: '.$r['course'].' — '.$r['learner'];
    $line = $price_cents; // qty 1
    $ii = db()->prepare("INSERT INTO invoice_items(invoice_id,course_id,learner_id,description,qty,unit_cents,line_cents)
                         VALUES(?,?,?,?,1,?,?)");
    $ii->execute([$invId,$r['course_id'],$r['user_id'],$desc,$price_cents,$line]);
    $total += $line;
  }

  db()->prepare("UPDATE invoices SET total_cents=? WHERE id=?")->execute([$total,$invId]);
  db()->commit();
  header('Location: '.url('company/invoices.php?id='.$invId));
  exit;
} catch(Throwable $e){
  db()->rollBack();
  echo "Error generating invoice.";
}
