<?php
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/helpers.php';
require_once __DIR__ . '/../lib/csrf.php';

require_login();

// require approval
$u = current_user();
$cid = db()->prepare("SELECT c.id,c.status FROM companies c JOIN company_user_map m ON m.company_id=c.id WHERE m.user_id=? LIMIT 1");
$cid->execute([$u['id']]);
$c = $cid->fetch();
if (!$c) { http_response_code(403); echo "No company linked."; exit; }
if ($c['status']!=='approved') { echo "<div class='alert alert-error'>Your company is pending admin approval.</div>"; include __DIR__.'/../templates/footer.php'; exit; }


// Find the company this user represents (via mapping)
$st = db()->prepare("
  SELECT c.*
  FROM company_user_map m
  JOIN companies c ON c.id=m.company_id
  WHERE m.user_id=? AND m.role IN ('company_rep','viewer')
  LIMIT 1
");
$st->execute([$u['id']]);
$c = $st->fetch();

if (empty($c['approved_at'])): ?>
  <div class="alert alert-warning" style="max-width:820px;">
    <strong>Your company is pending admin approval.</strong><br>
    You can fill your company profile, but features like bulk enroll and invoicing will activate after approval.
  </div>
<?php endif; ?>


if (!$c) {
  include __DIR__ . '/../templates/header.php';
  echo "<h1>Company Settings</h1>";
  echo "<div class='alert alert-error'>No company linked to your account.</div>";
  echo "<p><a class='btn' href='".e(url('company/create.php'))."'>Create my company</a></p>";
  include __DIR__ . '/../templates/footer.php';
  exit;
}

$msg=''; $err='';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  verify_csrf_or_die();
  $name          = trim($_POST['name'] ?? $c['name']);
  $reg_no        = trim($_POST['reg_no'] ?? ($c['reg_no'] ?? ''));
  $logo_url      = trim($_POST['logo_url'] ?? ($c['logo_url'] ?? ''));
  $address       = trim($_POST['address'] ?? ($c['address'] ?? ''));
  $billing_email = trim($_POST['billing_email'] ?? ($c['billing_email'] ?? ''));
  $contact_phone = trim($_POST['contact_phone'] ?? ($c['contact_phone'] ?? ''));

  if ($name==='') { $err='Company name is required.'; }

  if (!$err) {
    $up = db()->prepare("
      UPDATE companies
         SET name=?, reg_no=?, logo_url=?, address=?, billing_email=?, contact_phone=?
       WHERE id=?
    ");
    $up->execute([$name,$reg_no,$logo_url,$address,$billing_email,$contact_phone,$c['id']]);
    $msg='Saved.';
    $st->execute([$u['id']]); $c = $st->fetch();
  }
}

include __DIR__ . '/../templates/header.php';
?>
<h1>Company Settings</h1>
<?php if ($msg): ?><div class="alert alert-ok"><?= e($msg) ?></div><?php endif; ?>
<?php if ($err): ?><div class="alert alert-error"><?= e($err) ?></div><?php endif; ?>

<form method="post" class="form-card" style="max-width:720px;">
  <?php csrf_field(); ?>
  <label class="field">
    <span class="field__label">Company name</span>
    <input class="field__input" name="name" value="<?= e($c['name']) ?>" required>
  </label>
  <div class="grid-2">
    <label class="field">
      <span class="field__label">Registration no</span>
      <input class="field__input" name="reg_no" value="<?= e($c['reg_no'] ?? '') ?>">
    </label>
    <label class="field">
      <span class="field__label">Logo URL (HTTPS)</span>
      <input class="field__input" name="logo_url" value="<?= e($c['logo_url'] ?? '') ?>" placeholder="https://.../company_logo.png">
    </label>
  </div>
  <label class="field">
    <span class="field__label">Head office address</span>
    <textarea class="field__input" name="address" rows="3" placeholder="Street, City, Postal code, Country"><?= e($c['address'] ?? '') ?></textarea>
  </label>
  <div class="grid-2">
    <label class="field">
      <span class="field__label">Billing email</span>
      <input class="field__input" name="billing_email" value="<?= e($c['billing_email'] ?? '') ?>" placeholder="accounts@company.co.za">
    </label>
    <label class="field">
      <span class="field__label">Main contact phone</span>
      <input class="field__input" name="contact_phone" value="<?= e($c['contact_phone'] ?? '') ?>" placeholder="+27 ...">
    </label>
  </div>

  <div class="form__actions">
    <button class="btn btn-primary">Save</button>
    <a class="btn btn-outline" href="<?= e(url('company/')) ?>">Back</a>
  </div>
</form>
<?php include __DIR__ . '/../templates/footer.php'; ?>
