<?php
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__ . '/../lib/auth.php';
require_once __DIR__ . '/../lib/db.php';
require_once __DIR__ . '/../lib/helpers.php';
require_login();
if (!can('admin')) { http_response_code(403); echo "Admins only."; exit; }

$id = (int)($_GET['id'] ?? 0);
$st = db()->prepare("SELECT * FROM companies WHERE id=? LIMIT 1");
$st->execute([$id]);
$c = $st->fetch();
if (!$c) { echo "Company not found."; exit; }
include __DIR__ . '/../templates/header.php';
?>
<h1>Company: <?= e($c['name']) ?></h1>
<table class="mini">
  <tr><th>Logo</th><td><?= $c['logo_url'] ? '<img src="'.e($c['logo_url']).'" style="max-height:40px">' : '—' ?></td></tr>
  <tr><th>Address</th><td><?= nl2br(e($c['address'] ?? '—')) ?></td></tr>
  <tr><th>Billing email</th><td><?= e($c['billing_email'] ?? '—') ?></td></tr>
  <tr><th>Contact phone</th><td><?= e($c['contact_phone'] ?? '—') ?></td></tr>
  <tr><th>Approved at</th><td><?= e($c['approved_at'] ?? '—') ?></td></tr>
</table>
<p><a class="btn" href="<?= e(url('admin/companies_queue.php')) ?>">Back to queue</a></p>
<?php include __DIR__ . '/../templates/footer.php'; ?>
