<?php
require_once __DIR__.'/lib/auth.php';
require_once __DIR__.'/lib/db.php';
require_once __DIR__.'/lib/helpers.php';

$q = trim($_GET['q'] ?? '');
$params = [];

// Pull courses + comma-list of categories (if any)
$sql = "
SELECT c.id, c.title, c.description, c.duration_days, c.type,
       c.nqf_level, c.credits, c.course_number, c.expiry_months,
       c.price, c.thumbnail_url,
       GROUP_CONCAT(cc.name ORDER BY cc.name SEPARATOR ', ') AS cats
FROM courses c
LEFT JOIN course_category_map m ON m.course_id = c.id
LEFT JOIN course_categories cc ON cc.id = m.category_id
";

if ($q !== '') {
  $sql .= "WHERE c.title LIKE ? OR c.description LIKE ? ";
  $like = '%'.$q.'%';
  $params = [$like,$like];
}

$sql .= "GROUP BY c.id
ORDER BY c.title";

$st = db()->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();

include __DIR__.'/templates/header.php';
?>
<h1>Courses</h1>

<form method="get" class="form-card" style="margin-bottom:12px;">
  <label class="field">
    <span class="field__label">Search</span>
    <input class="field__input" name="q" value="<?= e($q) ?>" placeholder="e.g. Defensive Driving">
  </label>
  <div class="form__actions">
    <button class="btn btn-primary btn-small">Search</button>
    <?php if (can('admin')): ?>
      <a class="btn btn-small" href="<?= e(url('admin/courses.php')) ?>">Manage Courses</a>
      <a class="btn btn-small" href="<?= e(url('admin/course_categories.php')) ?>">Manage Categories</a>
    <?php endif; ?>
  </div>
</form>

<?php if (!$rows): ?>
  <p class="muted">No courses yet.</p>
<?php else: ?>
  <div class="courses-grid">
    <?php foreach($rows as $r): ?>
      <?php
        $img = trim((string)($r['thumbnail_url'] ?? ''));
        if ($img === '') $img = url('assets/img/course-placeholder.jpg'); // fallback image (optional)
      ?>
      <a class="course-card" href="<?= e(url('course_view.php?id='.(int)$r['id'])) ?>">
        <div class="course-thumb" style="background-image:url('<?= e($img) ?>');"></div>
        <div class="course-body">
          <h3 class="course-title"><?= e($r['title']) ?></h3>
          <div class="chips" style="margin:6px 0;">
            <?php if (!empty($r['type'])): ?>
              <span class="chip"><?= e($r['type']) ?></span>
            <?php endif; ?>
            <?php if (!empty($r['nqf_level'])): ?>
              <span class="chip">NQF L<?= (int)$r['nqf_level'] ?></span>
            <?php endif; ?>
            <?php if (!empty($r['credits'])): ?>
              <span class="chip"><?= (int)$r['credits'] ?> credits</span>
            <?php endif; ?>
            <?php if (!empty($r['duration_days'])): ?>
              <span class="chip"><?= (int)$r['duration_days'] ?> days</span>
            <?php endif; ?>
            <?php if (!empty($r['expiry_months'])): ?>
              <span class="chip">Expires <?= (int)$r['expiry_months'] ?> mo</span>
            <?php endif; ?>
          </div>
          <?php if (!empty($r['cats'])): ?>
            <div class="muted" style="font-size:12px; margin:4px 0 6px 0;">
              <?= e($r['cats']) ?>
            </div>
          <?php endif; ?>
          <div class="course-footer">
            <div class="course-price">
              <?php if (!is_null($r['price'])): ?>
                R <?= number_format((float)$r['price'], 2) ?>
              <?php else: ?>
                <span class="muted">Price on request</span>
              <?php endif; ?>
            </div>
            <div>
              <?php if (is_logged_in()): ?>
                <span class="btn btn-small">Enroll</span>
              <?php else: ?>
                <span class="btn btn-small">View</span>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </a>
    <?php endforeach; ?>
  </div>
<?php endif; ?>

<?php include __DIR__.'/templates/footer.php'; ?>
