<?php
// cron/recompute_scores.php — compute weekly scores from last 7 days of events
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__.'/../lib/db.php';

$weekAgo = date('Y-m-d H:i:s', time() - 7*86400);

// Get drivers having events in last 7 days
$drivers = db()->prepare("
  SELECT user_id, COUNT(*) AS cnt, AVG(severity_score) AS avgsev
    FROM driver_events
   WHERE event_timestamp >= ?
   GROUP BY user_id
");
$drivers->execute([$weekAgo]);
$list = $drivers->fetchAll();

$ins = db()->prepare("INSERT INTO driver_scores(user_id,score,category,source,recorded_at) VALUES(?,?,?,?,NOW())");

foreach ($list as $row) {
  $uid   = (int)$row['user_id'];
  $avg   = (float)$row['avgsev'];
  // Simple model: 100 - average severity
  $score = max(0, min(100, (int)round(100 - $avg)));
  $ins->execute([$uid, $score, 'weekly', 'computed']);
}

echo "computed ".count($list)." weekly scores\n";
