<?php
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__ . '/lib/db.php';

function showCols($table){
  echo "<h3>Table: $table</h3>";
  try{
    $st = db()->prepare("SHOW COLUMNS FROM `$table`");
    $st->execute();
    echo "<table border=1 cellpadding=4><tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    foreach($st->fetchAll() as $r){
      echo "<tr><td>{$r['Field']}</td><td>{$r['Type']}</td><td>{$r['Null']}</td><td>{$r['Key']}</td><td>{$r['Default']}</td><td>{$r['Extra']}</td></tr>";
    }
    echo "</table>";
  }catch(Throwable $e){
    echo "<p style='color:#b00'>Error reading $table: ".$e->getMessage()."</p>";
  }
}

echo "<h2>DB Schema Probe</h2>";
showCols('users');
showCols('courses');
showCols('enrollments');
showCols('modules');
showCols('submissions');
showCols('results');
showCols('certificates');
