<?php
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';
require_once __DIR__ . '/lib/csrf.php';

require_login();
$u = current_user();

$can_enroll = can('admin') || can('grade'); // existing staff
// company reps can enroll their drivers
try {
  if (!$can_enroll) {
    $st = db()->prepare("SELECT 1 FROM company_user_map WHERE user_id=? AND role='company_rep' LIMIT 1");
    $st->execute([$u['id']]);
    $can_enroll = (bool)$st->fetch();
  }
  // learners can enroll themselves
  if (!$can_enroll && ($u['role'] ?? '') === 'learner') $can_enroll = true;
} catch (Throwable $e) { /* keep default */ }

if (!$can_enroll) { http_response_code(403); echo "You cannot enroll learners."; exit; }


require_once __DIR__ . '/lib/demo.php';
demo_guard(); // blocks POST in demo mode

function ensure_enrollments_table(){
  $sql = "CREATE TABLE IF NOT EXISTS enrollments (
            id INT NOT NULL AUTO_INCREMENT,
            user_id INT NOT NULL,
            course_id INT NOT NULL,
            enrolled_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            UNIQUE KEY uq_enr_user_course (user_id, course_id),
            KEY idx_enr_user (user_id),
            KEY idx_enr_course (course_id)
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
  db()->exec($sql);
}
ensure_enrollments_table();

$msg=''; $err='';
if ($_SERVER['REQUEST_METHOD']==='POST'){
    verify_csrf_or_die();
  $user_id   = (int)($_POST['user_id'] ?? 0);
  $course_id = (int)($_POST['course_id'] ?? 0);

  if ($user_id<=0 || $course_id<=0) {
    $err = "Please choose a learner and a course.";
  } else {
    // prevent duplicates (unique key will handle, but we do a check too)
    $s=db()->prepare("SELECT 1 FROM enrollments WHERE user_id=? AND course_id=?");
    $s->execute([$user_id,$course_id]);
    if ($s->fetch()){
      $msg = "Learner is already enrolled on this course.";
    } else {
      $ins = db()->prepare("INSERT INTO enrollments (user_id,course_id) VALUES (?,?)");
      $ins->execute([$user_id,$course_id]);
      $msg = "Enrolled learner successfully.";
    }
  }
}

$learners = db()->query("SELECT id,name,email FROM users WHERE role='learner' ORDER BY name")->fetchAll();
$courses  = db()->query("SELECT id,title FROM courses ORDER BY title")->fetchAll();

include __DIR__ . '/templates/header.php';
?>
<h1>Enroll Learner</h1>
<?php if($msg): ?><div class="alert alert-ok"><?=e($msg)?></div><?php endif; ?>
<?php if($err): ?><div class="alert alert-error"><?=e($err)?></div><?php endif; ?>

<form method="post" class="form-card">
    <?php csrf_field(); ?>

  <label class="field">
    <span class="field__label">Learner</span>
    <select name="user_id" class="field__input" required>
      <option value="">-- choose learner --</option>
      <?php foreach($learners as $L): ?>
        <option value="<?=$L['id']?>"><?=e($L['name'])?> (<?=e($L['email'])?>)</option>
      <?php endforeach; ?>
    </select>
  </label>

  <label class="field">
    <span class="field__label">Course</span>
    <select name="course_id" class="field__input" required>
      <option value="">-- choose course --</option>
      <?php foreach($courses as $C): ?>
        <option value="<?=$C['id']?>"><?=e($C['title'])?></option>
      <?php endforeach; ?>
    </select>
  </label>

  <div class="form__actions">
    <button class="btn btn-primary" type="submit">Enroll</button>
    <a class="btn btn-outline" href="<?=e(url('dashboard.php'))?>">Back</a>
  </div>
</form>
<?php include __DIR__ . '/templates/footer.php'; ?>
