<?php
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/db.php';
require_login();
require_once __DIR__ . '/lib/demo.php';
demo_guard(); // blocks POST in demo mode

require_ability('report'); // only admins/assessors

require __DIR__ . '/vendor/autoload.php'; // PhpSpreadsheet

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Pick report type from ?type=
$type = $_GET['type'] ?? 'learners';
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

if ($type === 'learners') {
    $rows = db()->query("SELECT id,name,email,role,created_at FROM users ORDER BY id")->fetchAll();
    $sheet->setCellValue('A1','ID')->setCellValue('B1','Name')->setCellValue('C1','Email')->setCellValue('D1','Role')->setCellValue('E1','Joined');
    $r=2;
    foreach($rows as $row){
        $sheet->setCellValue("A$r",$row['id'])
              ->setCellValue("B$r",$row['name'])
              ->setCellValue("C$r",$row['email'])
              ->setCellValue("D$r",$row['role'])
              ->setCellValue("E$r",$row['created_at']);
        $r++;
    }
    $sheet->setTitle('Learners');
}

$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="report-'.$type.'.xlsx"');
$writer->save('php://output');
exit;
