<?php
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/db.php';
require_login();
require_ability('report');

require __DIR__ . '/vendor/autoload.php'; // Dompdf

use Dompdf\Dompdf;
use Dompdf\Options;

$type = $_GET['type'] ?? 'learners';
$rows = db()->query("SELECT id,name,email,role,created_at FROM users ORDER BY id")->fetchAll();

$html = '<h2>Africa In Training — '.$type.' report</h2><table border="1" cellpadding="5" cellspacing="0"><tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Joined</th></tr>';
foreach($rows as $row){
    $html .= '<tr><td>'.$row['id'].'</td><td>'.$row['name'].'</td><td>'.$row['email'].'</td><td>'.$row['role'].'</td><td>'.$row['created_at'].'</td></tr>';
}
$html .= '</table>';

$options = new Options();
$options->set('isRemoteEnabled',true);
$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4','landscape');
$dompdf->render();
$dompdf->stream('report-'.$type.'.pdf', ['Attachment'=>true]);
