<?php
require_once __DIR__ . '/lib/auth.php'; require_once __DIR__ . '/lib/helpers.php';
require_once __DIR__ . '/lib/config.php'; require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/policy.php'; require_login(); include __DIR__ . '/templates/header.php';

$msg='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $txt=trim($_POST['message']??'');
  if($txt!==''){
    $fname=time().'_'.current_user()['id'].'.txt';
    file_put_contents(GRIEVANCE_DIR.'/'.$fname,$txt);
    $s=db()->prepare("INSERT INTO grievances(user_id,message,file_ref) VALUES(?,?,?)");
    $s->execute([current_user()['id'],$txt,$fname]); $msg="Submitted grievance.";
  }
}
$mine=db()->prepare("SELECT * FROM grievances WHERE user_id=? ORDER BY id DESC");
$mine->execute([current_user()['id']]); $mine=$mine->fetchAll();
$all=[]; if(can('report')){
  $all=db()->query("SELECT g.*,u.email FROM grievances g LEFT JOIN users u ON u.id=g.user_id ORDER BY g.id DESC")->fetchAll();
}
?>
<h2>Grievances / Complaints</h2>
<?php if($msg): ?><p><?=e($msg)?></p><?php endif; ?>
<form method="post">
  <label>Describe your complaint:<br><textarea name="message" rows="4" cols="60" required></textarea></label><br>
  <button type="submit">Send</button>
</form>
<h3>Your submissions</h3><ul>
  <?php foreach($mine as $g): ?><li>#<?=$g['id']?> — <?=e($g['message'])?> (<?=e($g['created_at'])?>)</li><?php endforeach; ?>
</ul>
<?php if($all): ?><h3>All grievances (staff view)</h3><ul>
  <?php foreach($all as $g): ?><li>#<?=$g['id']?> — <?=e($g['email'])?>: <?=e($g['message'])?> (<?=e($g['created_at'])?>)</li><?php endforeach; ?>
</ul><?php endif; include __DIR__ . '/templates/footer.php'; ?>
