<?php
// Front door landing page for AIT LMIS
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/helpers.php';

$u = current_user();
include __DIR__ . '/templates/header.php';
?>

<!-- Full-bleed hero section -->
<section class="hero full-bleed" role="banner" aria-label="AIT LMIS hero">
  <div class="hero__inner">
    <div class="hero__left">
      <div class="hero__badge">TETA-aligned • POPIA-friendly</div>
      <h1 class="hero__title">Africa In Training — LMIS</h1>
      <p class="hero__subtitle">
        A modern, Generative-AI powered learning system.
        Simple for learners. Powerful for assessors & moderators. 
        Verifiable certificates with QR & cryptographic hash.
      </p>

      <?php if ($u): ?>
        <div class="hero__cta">
          <a class="btn btn-primary" href="<?= e(url('dashboard.php')) ?>" aria-label="Continue to your dashboard">
            Continue to Dashboard
          </a>
          <a class="btn btn-outline" href="<?= e(url('courses.php')) ?>" aria-label="View available courses">
            View Courses
          </a>
        </div>
        <p class="hero__tiny">Logged in as <strong><?= e($u['name']) ?></strong>.</p>
      <?php else: ?>
        <div class="hero__cta">
          <a class="btn btn-primary" href="<?= e(url('login.php')) ?>" aria-label="Login to AIT LMIS">
            Login
          </a>
          <a class="btn btn-outline" href="<?= e(url('register.php')) ?>" aria-label="Create a new account">
            Register
          </a>
        </div>
        <p class="hero__tiny">No account yet? Click <strong>Register</strong> to get started — it’s quick.</p>
      <?php endif; ?>
    </div>

    <div class="hero__right" aria-hidden="true">
      <div class="hero__glass">
        <ul class="hero__points">
          <li>AI Tutor for instant help</li>
          <li>Digital POE uploads & tracking</li>
          <li>Assessor grading with AI draft feedback</li>
          <li>QR-secured, hash-sealed certificates</li>
          <li>Moderator oversight & audit trails</li>
        </ul>
      </div>
    </div>
  </div>
</section>

<!-- Persona cards -->
<section class="persona-grid" aria-label="Start as your role">
  <h2 class="section-title">Start as your role</h2>
  <div class="grid">
    <article class="card">
      <h3>Learner</h3>
      <p>Enroll, study online, upload your POE, chat with the AI Tutor, and track your progress.</p>
      <div class="card-actions">
        <a class="btn btn-small btn-primary" href="<?= e(url('register.php')) ?>">Register</a>
        <a class="btn btn-small btn-outline" href="<?= e(url('login.php')) ?>">Login</a>
      </div>
    </article>

    <article class="card">
      <h3>Assessor</h3>
      <p>Review POEs, record C/NYC decisions, generate AI draft feedback, and issue certificates.</p>
      <div class="card-actions">
        <a class="btn btn-small btn-primary" href="<?= e(url('login.php')) ?>">Assessor Login</a>
      </div>
    </article>

    <article class="card">
      <h3>Moderator</h3>
      <p>Sample assessments, verify evidence quality, and lock results with full audit trail.</p>
      <div class="card-actions">
        <a class="btn btn-small btn-primary" href="<?= e(url('login.php')) ?>">Moderator Login</a>
      </div>
    </article>

    <article class="card">
      <h3>TETA Read-only</h3>
      <p>Compliance view: read-only access to learner stats, results, and certificate verification.</p>
      <div class="card-actions">
        <a class="btn btn-small btn-primary" href="<?= e(url('login.php')) ?>">TETA Portal</a>
      </div>
    </article>
  </div>
</section>

<!-- Trust strip -->
<section class="trust-strip" aria-label="Compliance and verification">
  <div class="trust__logos">
    <img class="trust__logo" src="<?= e(url('assets/img/teta_logo.png')) ?>" alt="TETA logo">
    <img class="trust__logo" src="<?= e(url('assets/img/ait_logo.png')) ?>" alt="AIT logo">
  </div>
  <ul class="trust__bullets">
    <li>POPIA-friendly data handling</li>
    <li>Role-based access (Learner, Assessor, Moderator, TETA view)</li>
    <li>Tamper-evident certificates (QR + hash)</li>
    <li>Exportable reports (CSV / Excel / PDF)</li>
  </ul>
</section>

<?php include __DIR__ . '/templates/footer.php'; ?>
