<?php
// integrations/scores_ingest.php — JSON POST { token, payload: [...] }
ini_set('display_errors',1); error_reporting(E_ALL);
require_once __DIR__.'/../lib/db.php';
require_once __DIR__.'/../lib/helpers.php';
require_once __DIR__.'/../lib/config.php';

header('Content-Type: application/json');

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
if ($method !== 'POST') { http_response_code(405); echo json_encode(['error'=>'POST only']); exit; }

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
if (!$data || ($data['token'] ?? '') !== INGEST_TOKEN) {
  http_response_code(401); echo json_encode(['error'=>'bad token']); exit;
}
$payload = $data['payload'] ?? [];
if (!is_array($payload)) { http_response_code(400); echo json_encode(['error'=>'bad payload']); exit; }

$insScores=0; $insEvents=0;
foreach ($payload as $row) {
  // Two accepted shapes:
  // A) score:  { type:'score', email:'x@x', user_id:123, score:72, category:'weekly', recorded_at:'YYYY-MM-DD HH:MM:SS', source:'surfsight' }
  // B) event:  { type:'event', email:'x@x', user_id:123, event_type:'harsh_brake', severity_score:80, event_timestamp:'...', source:'surfsight', metadata:{...} }

  $type = $row['type'] ?? '';
  $uid  = 0;
  if (!empty($row['user_id'])) $uid = (int)$row['user_id'];
  elseif (!empty($row['email'])) {
    $st=db()->prepare("SELECT id FROM users WHERE email=? LIMIT 1"); $st->execute([$row['email']]); $r=$st->fetch(); if ($r) $uid=(int)$r['id'];
  }
  if (!$uid) continue;

  if ($type==='score') {
    $st=db()->prepare("INSERT INTO driver_scores(user_id,score,category,source,recorded_at) VALUES(?,?,?,?,?)");
    $st->execute([
      $uid,
      (int)($row['score']??0),
      trim($row['category']??'weekly'),
      trim($row['source']??'api'),
      trim($row['recorded_at']??date('Y-m-d H:i:s'))
    ]);
    $insScores++;
  } elseif ($type==='event') {
    $meta = isset($row['metadata']) ? json_encode($row['metadata']) : null;
    $st=db()->prepare("INSERT INTO driver_events(user_id,event_type,severity_score,event_timestamp,source,metadata) VALUES(?,?,?,?,?,?)");
    $st->execute([
      $uid,
      trim($row['event_type']??'unknown'),
      (int)($row['severity_score']??0),
      trim($row['event_timestamp']??date('Y-m-d H:i:s')),
      trim($row['source']??'api'),
      $meta
    ]);
    $insEvents++;
  }
}

echo json_encode(['ok'=>true,'scores_inserted'=>$insScores,'events_inserted'=>$insEvents]);
