<?php
require_once __DIR__ . '/config.php';

// Send a chat to your LLM. $messages is an array of ["role"=>"system|user|assistant","content"=>"..."].
function llm_chat($messages, $json = false){
  $payload = [
    'model' => LLM_MODEL,
    'messages' => $messages,
    // You can add temperature, max_tokens if your provider supports it.
  ];
  $ch = curl_init(LLM_BASE . '/chat/completions');
  curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
      'Content-Type: application/json',
      'Authorization: Bearer ' . LLM_API_KEY,
    ],
    CURLOPT_POSTFIELDS => json_encode($payload),
  ]);
  $res = curl_exec($ch);
  if($res === false){ return ['error'=>curl_error($ch)]; }
  $data = json_decode($res,true);
  // Adjust path to match your provider:
  $text = $data['choices'][0]['message']['content'] ?? '';
  if($json){
    // try to parse JSON answer
    $first = trim($text);
    $first = trim($first, " \t\n\r\0\x0B`");
    $parsed = json_decode($first,true);
    return $parsed ?: ['raw'=>$text];
  }
  return ['text'=>$text];
}

// Default “safety coach” system prompt used across AI features.
function ai_system_prompt(){
return <<<SYS
You are AIT, an E-learning safety tutor for transport logistics (TETA context).
Rules:
- Be concise, friendly, step-by-step, plain English.
- Always prioritise safety and compliance. If a scenario is high-risk, advise to ask an assessor.
- Never invent accreditation or outcomes. If unsure, ask for clarity.
- Offer low-data options (text over video) when possible.
SYS;
}
