<?php
// lib/cert.php — certificate helper
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/helpers.php';
require_once __DIR__ . '/tracking.php'; // for audit()

/**
 * issue_certificate
 * - creates a certificate row if one does not already exist for (user, course)
 * - returns the cert array (id, code, hash, issued_at, etc.)
 */
function issue_certificate(int $user_id, int $course_id){
  // Check if already exists
  $chk = db()->prepare("SELECT * FROM certificates WHERE user_id=? AND course_id=? ORDER BY id DESC LIMIT 1");
  $chk->execute([$user_id, $course_id]);
  $exists = $chk->fetch();
  if ($exists) return $exists;

  // Make a short code and a hash (crypto fingerprint)
  $code = 'C'.bin2hex(random_bytes(4)); // e.g., C9a12bcd
  $secret = 'CHANGE_ME_SALT'; // move to config if preferred
  $data = $user_id.'|'.$course_id.'|'.date('Y-m-d H:i:s').'|'.$secret;
  $hash = hash('sha256', $data);

  $ins = db()->prepare("INSERT INTO certificates(user_id, course_id, cert_code, cert_hash) VALUES (?,?,?,?)");
  $ins->execute([$user_id, $course_id, $code, $hash]);

  audit('certificate.issue', ['user_id'=>$user_id, 'course_id'=>$course_id, 'cert_code'=>$code]);

  $get = db()->prepare("SELECT * FROM certificates WHERE cert_code=?");
  $get->execute([$code]);
  return $get->fetch();
}
