<?php
// lib/csrf.php — simple CSRF protection

if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

// Generate and store a CSRF token in session
function csrf_token(): string {
  if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(16));
  }
  return $_SESSION['csrf_token'];
}

// Echo a hidden input for forms
function csrf_field(): void {
  echo '<input type="hidden" name="csrf_token" value="' . e(csrf_token()) . '">';
}

// Verify incoming token (POST forms)
function verify_csrf_or_die(): void {
  if ($_SERVER['REQUEST_METHOD'] !== 'POST') return;
  $token = $_POST['csrf_token'] ?? '';
  if (!$token || !hash_equals($_SESSION['csrf_token'] ?? '', $token)) {
    http_response_code(403);
    echo "CSRF token mismatch. Please reload the page and try again.";
    exit;
  }
}
