<?php
// lib/demo.php — tiny helpers for Presentation/Demo Mode (DRY/KISS).

// Is demo mode on?
function demo_enabled(): bool {
  return defined('DEMO_MODE') && DEMO_MODE === false;
}

// Show a yellow banner so everyone knows it's a demo.
function demo_banner_html(): string {
  if (!demo_enabled()) return '';
  $txt = defined('DEMO_BANNER') ? DEMO_BANNER : 'Presentation Demo — No real data is changed.';
  return '<div style="background:#fff7cc;border-bottom:1px solid #f3e38a;padding:8px 12px;color:#5a4b00;text-align:center;font-weight:600;">'
       . htmlspecialchars($txt, ENT_QUOTES, 'UTF-8')
       . '</div>';
}

// Stop any write/change when demo is ON (protect your real data).
function demo_guard(): void {
  if (!demo_enabled()) return;

  // Allow GET-only pages to continue (viewing is fine).
  $method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
  if ($method === 'GET') return;

  // If we got here, it’s a POST/PUT/DELETE — BLOCK it.
  http_response_code(403);
  echo "<h2>❌ Action disabled in Presentation Demo</h2>
        <p>This is a read-only demo. No changes are saved.</p>
        <p><a href='javascript:history.back()'>Go back</a></p>";
  exit;
}

// Optional: demo dashboard sample data
function demo_dashboard_boost(&$cards, &$sections, &$quick): void {
  if (!demo_enabled()) return;

  // If empty, add some attractive demo numbers
  if (empty($cards)) {
    $cards = [
      ['title'=>'Pending POEs','value'=>6,'hint'=>'Demo data','link'=>'#'],
      ['title'=>'Verify NYC','value'=>3,'hint'=>'Demo data','link'=>'#'],
      ['title'=>'Issue Certificates','value'=>12,'hint'=>'Demo data','link'=>'#'],
    ];
  }

  // Add a nice “What you can do” panel
  $sections[] = [
    'title' => 'Demo Highlights',
    'body'  => "<ul class='bullets'>
      <li>Blended learning with auto-saved progress</li>
      <li>Assessor & moderator transparency</li>
      <li>Secure certificates with QR + hash</li>
      <li>Company bulk onboarding (Excel)</li>
    </ul>"
  ];

  // Add quick buttons (disabled links)
  $quick[] = ['label'=>'Try AI Tutor (demo)', 'href'=>'#'];
  $quick[] = ['label'=>'View Certificates',   'href'=>'#'];
}
