<?php
// lib/helpers.php — clean, DRY, KISS helpers

require_once __DIR__ . '/config.php';

// HTML escape
function e($s) {
  return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
}

// Build app URL (always from BASE_URL)
function url(string $path = ''): string {
  $base = rtrim(BASE_URL, '/');  // e.g. https://ncdigital.co.za/lmis
  $path = ltrim($path, '/');
  return $path ? ($base . '/' . $path) : $base;
}

// Full URL (same as url(), for emails/QR)
function full_url(string $path = ''): string {
  return url($path);
}

// Redirect and exit
function redirect(string $path) {
  header('Location: ' . url($path));
  exit;
}
