<?php
// lib/recommend.php — tiny helper for driver-score → course recommendation
// No self-includes. Only needs lib/db.php.

require_once __DIR__ . '/db.php';

/**
 * Get the latest driver score for a learner.
 * Looks in driver_scores(user_id, score, category, recorded_at).
 */
function latest_driver_score(int $user_id, string $category = 'weekly'): ?array {
  try {
    $st = db()->prepare("
      SELECT id, user_id, score, category, source, created_at, recorded_at
      FROM driver_scores
      WHERE user_id = ? AND category = ?
      ORDER BY recorded_at DESC, id DESC
      LIMIT 1
    ");
    $st->execute([$user_id, $category]);
    $row = $st->fetch();
    return $row ?: null;
  } catch (Throwable $e) {
    return null; // fail quietly
  }
}

/**
 * Map a score to one recommended course using driver_score_recos.
 * Table: driver_score_recos(score_min, score_max, course_id)
 */
function recommended_course_for_score(int $score): ?array {
  try {
    $st = db()->prepare("
      SELECT r.course_id, c.title
      FROM driver_score_recos r
      JOIN courses c ON c.id = r.course_id
      WHERE ? BETWEEN r.score_min AND r.score_max
      LIMIT 1
    ");
    $st->execute([$score]);
    $row = $st->fetch();
    return $row ?: null;
  } catch (Throwable $e) {
    return null;
  }
}
