<?php
// llm_probe.php — quick robot doctor page (delete after testing!)
require_once __DIR__ . '/lib/config.php';

// Build a tiny chat completion payload
$payload = [
  'model' => (defined('LLM_MODEL') ? LLM_MODEL : 'gpt-4o-mini'),
  'messages' => [
    ['role' => 'system', 'content' => 'You are helpful. Answer briefly.'],
    ['role' => 'user',   'content' => 'Say "hello" in one word.']
  ],
];

$endpoint = rtrim((defined('LLM_BASE') ? LLM_BASE : 'https://api.openai.com/v1'), '/')
          . '/chat/completions';

// Prepare request
$ch = curl_init($endpoint);
curl_setopt_array($ch, [
  CURLOPT_POST           => true,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_HTTPHEADER     => [
    'Content-Type: application/json',
    'Authorization: Bearer ' . (defined('LLM_API_KEY') ? LLM_API_KEY : ''),
  ],
  CURLOPT_POSTFIELDS     => json_encode($payload),
  CURLOPT_TIMEOUT        => 30,
]);

// Do call
$res  = curl_exec($ch);
$err  = curl_error($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Pretty print (but DON’T show the secret key)
function h($s){ return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

echo "<h2>LLM Probe</h2>";
echo "<p><b>Endpoint:</b> ".h($endpoint)."</p>";
echo "<p><b>Model:</b> ".h($payload['model'])."</p>";
echo "<p><b>HTTP status:</b> ".h((string)$http)."</p>";

if ($err){
  echo "<p style='color:#b00'><b>cURL error:</b> ".h($err)."</p>";
}

if ($res !== false){
  echo "<h3>Raw JSON response</h3>";
  // Try to pretty-print JSON
  $json = json_decode($res, true);
  if (json_last_error() === JSON_ERROR_NONE){
    echo "<pre>".h(json_encode($json, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES))."</pre>";
    // Also try to show the first message content if available
    $text = $json['choices'][0]['message']['content'] ?? '';
    if ($text){
      echo "<h3>First message content</h3><pre>".h($text)."</pre>";
    }
  } else {
    echo "<pre>".h($res)."</pre>";
  }
}
