<?php
ini_set('display_errors',1); error_reporting(E_ALL);
// login.php — AIT LMIS modern login
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/db.php';
require_once __DIR__ . '/lib/helpers.php';

// ✅ ADD THIS LINE: load the CSRF helper
require_once __DIR__ . '/lib/csrf.php';

if (is_logged_in()) {
  redirect('dashboard.php');
}

$err = '';
$email = '';

// 2) When the form is submitted (POST), first verify CSRF token
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  // ✅ This line checks the hidden token. If missing/wrong, it stops the request safely.
  verify_csrf_or_die();
  
  $email = trim($_POST['email'] ?? '');
  $pass  = $_POST['password'] ?? '';

  if ($email === '' || $pass === '') {
    $err = 'Please enter both email and password.';
  } else {
    $s = db()->prepare("SELECT id, name, email, password_hash, role FROM users WHERE email=? LIMIT 1");
    $s->execute([$email]);
    $u = $s->fetch();

    if ($u && password_verify($pass, $u['password_hash'])) {
      // start session + set user
      login_user($u['id']); // this function should set session; it likely lives in lib/auth.php
      redirect('dashboard.php');
    } else {
      $err = 'Email or password is incorrect.';
    }
  }
}

// Show the page (HTML starts here)
include __DIR__ . '/templates/header.php';
?>
<h1 style="margin-bottom:10px;">Welcome back</h1>
<p class="small" style="margin-top:0;">Log in to your AIT LMIS account.</p>

<form method="post" class="form-card" novalidate>
  <?php csrf_field(); ?>

  <?php if ($err): ?>
    <div class="alert alert-error"><?= e($err) ?></div>
  <?php endif; ?>

  <label class="field">
    <span class="field__label">Email</span>
    <input class="field__input" type="email" name="email" value="<?= e($email) ?>" placeholder="you@example.com" required>
  </label>

  <label class="field">
    <span class="field__label">Password</span>
    <input class="field__input" type="password" name="password" placeholder="••••••••" required>
  </label>

  <div class="form__actions">
    <button class="btn btn-primary" type="submit">Login</button>
    <a class="btn btn-outline" href="<?= e(url('register.php')) ?>">Create account</a>
  </div>

  <p class="small" style="margin-top:10px;">
    By continuing you agree to our
    <a href="<?= e(url('policies/Privacy-Policy.md')) ?>" target="_blank">Privacy Policy</a>
    and
    <a href="<?= e(url('policies/Code-of-Conduct.md')) ?>" target="_blank">Code of Conduct</a>.
  </p>
</form>

<?php include __DIR__ . '/templates/footer.php'; ?>
