<?php
// logout.php — end session and go to landing page
require_once __DIR__ . '/lib/auth.php';
require_once __DIR__ . '/lib/helpers.php';

// If logout_user() exists (from lib/auth.php), use it
if (function_exists('logout_user')) {
  logout_user();
} else {
  // Fallback: force-destroy session safely
  if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
  $_SESSION = [];
  if (ini_get('session.use_cookies')) {
    $p = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $p['path'], $p['domain'], $p['secure'], $p['httponly']);
  }
  session_destroy();
}

// After logout, send to login (or index)
redirect('login.php');
